/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.DefaultSkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class VampirismSkill<T extends IFactionPlayer>
extends DefaultSkill<T> {
    private Supplier<ITextComponent> description = () -> null;
    private Consumer<T> activate = player -> {};
    private Consumer<T> deactivate = player -> {};

    @Override
    public ITextComponent getDescription() {
        return this.description.get();
    }

    public VampirismSkill<T> setDescription(Supplier<ITextComponent> descriptionIn) {
        this.description = descriptionIn;
        return this;
    }

    public VampirismSkill<T> setHasDefaultDescription() {
        this.description = () -> new TranslationTextComponent(this.getTranslationKey() + ".desc");
        return this;
    }

    public VampirismSkill<T> setToggleActions(Consumer<T> activateIn, Consumer<T> deactivateIn) {
        this.activate = activateIn;
        this.deactivate = deactivateIn;
        return this;
    }

    @Override
    protected void onDisabled(T player) {
        this.deactivate.accept(player);
        super.onDisabled(player);
    }

    @Override
    protected void onEnabled(T player) {
        this.activate.accept(player);
        super.onEnabled(player);
    }

    public static class LordVampireSkill
    extends SimpleVampireSkill {
        public LordVampireSkill(boolean desc) {
            super(desc);
        }

        @Override
        public ISkillType getType() {
            return SkillType.LORD;
        }
    }

    public static class SimpleVampireSkill
    extends VampirismSkill<IVampirePlayer> {
        public SimpleVampireSkill(boolean desc) {
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Override
        @Nonnull
        public IPlayableFaction getFaction() {
            return VReference.VAMPIRE_FACTION;
        }

        @Override
        public ISkillType getType() {
            return SkillType.LEVEL;
        }
    }

    public static class LordHunterSkill
    extends SimpleHunterSkill {
        public LordHunterSkill(boolean desc) {
            super(desc);
        }

        @Override
        public ISkillType getType() {
            return SkillType.LORD;
        }
    }

    public static class SimpleHunterSkill
    extends VampirismSkill<IHunterPlayer> {
        public SimpleHunterSkill(boolean desc) {
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Override
        @Nonnull
        public IPlayableFaction getFaction() {
            return VReference.HUNTER_FACTION;
        }

        @Override
        public ISkillType getType() {
            return SkillType.LEVEL;
        }
    }
}

