/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.tasks.reward;

import de.teamlapen.lib.util.WeightedRandomItem;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.player.refinements.RefinementSet;
import de.teamlapen.vampirism.player.tasks.reward.ItemReward;
import de.teamlapen.vampirism.player.tasks.reward.ItemRewardInstance;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.WeightedRandom;

public class RefinementItemReward
extends ItemReward {
    private static final Random RANDOM = new Random();
    @Nullable
    private final IFaction<?> faction;
    @Nullable
    private final IRefinementSet.Rarity rarity;

    public RefinementItemReward(@Nullable IFaction<?> faction) {
        this(faction, null);
    }

    public RefinementItemReward(@Nullable IFaction<?> faction, @Nullable IRefinementSet.Rarity refinementRarity) {
        this(faction, () -> null, refinementRarity);
    }

    public RefinementItemReward(@Nullable IFaction<?> faction, @Nonnull Supplier<IRefinementItem> item, @Nullable IRefinementSet.Rarity refinementRarity) {
        super(() -> new ItemStack((IItemProvider)item.get()));
        this.faction = faction;
        this.rarity = refinementRarity;
    }

    @Override
    public ItemRewardInstance createInstance(IFactionPlayer<?> player) {
        return new ItemRewardInstance(this.createItem());
    }

    @Override
    public List<ItemStack> getAllPossibleRewards() {
        return !((ItemStack)this.reward.get()).func_190926_b() ? Collections.singletonList(new ItemStack((IItemProvider)((ItemStack)this.reward.get()).func_77973_b())) : this.getAllRefinementItems();
    }

    protected <Z extends Item> ItemStack createItem() {
        if (this.faction != null && !(this.faction instanceof IPlayableFaction)) {
            return ItemStack.field_190927_a;
        }
        IPlayableFaction<?> faction = (IPlayableFaction<?>)this.faction;
        if (faction == null) {
            faction = RefinementItemReward.getRandomFactionWithAccessories();
        }
        if (faction == null) {
            return ItemStack.field_190927_a;
        }
        IPlayableFaction<?> finalFaction = faction;
        Object item = faction.getRefinementItem(IRefinementItem.AccessorySlotType.values()[RANDOM.nextInt(IRefinementItem.AccessorySlotType.values().length)]);
        IRefinementItem.AccessorySlotType slot = ((IRefinementItem)item).getSlotType();
        List sets = ModRegistries.REFINEMENT_SETS.getValues().stream().filter(set -> set.getFaction() == finalFaction).filter(set -> this.rarity == null || set.getRarity().ordinal() >= this.rarity.ordinal()).filter(set -> set.getSlotType().map(slot1 -> slot1 == slot).orElse(true)).map(set -> ((RefinementSet)set).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return new ItemStack(item);
        }
        IRefinementSet set2 = (IRefinementSet)((WeightedRandomItem)WeightedRandom.func_76271_a((Random)RANDOM, sets)).getItem();
        ItemStack stack = new ItemStack(item);
        ((IRefinementItem)item).applyRefinementSet(stack, set2);
        return stack;
    }

    private List<ItemStack> getAllRefinementItems() {
        IPlayableFaction<?>[] iPlayableFactionArray;
        if (this.faction != null) {
            IPlayableFaction[] iPlayableFactionArray2 = new IPlayableFaction[1];
            iPlayableFactionArray = iPlayableFactionArray2;
            iPlayableFactionArray2[0] = (IPlayableFaction)this.faction;
        } else {
            iPlayableFactionArray = VampirismAPI.factionRegistry().getPlayableFactions();
        }
        return Arrays.stream(iPlayableFactionArray).filter(IPlayableFaction::hasRefinements).flatMap(function -> Arrays.stream(IRefinementItem.AccessorySlotType.values()).map(function::getRefinementItem)).map(a -> new ItemStack((IItemProvider)a)).collect(Collectors.toList());
    }

    @Nullable
    private static IPlayableFaction<?> getRandomFactionWithAccessories() {
        List factions = Arrays.stream(VampirismAPI.factionRegistry().getPlayableFactions()).filter(IPlayableFaction::hasRefinements).collect(Collectors.toList());
        if (factions.isEmpty()) {
            return null;
        }
        return (IPlayableFaction)factions.get(RANDOM.nextInt(factions.size()) - 1);
    }
}

