/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;

public class VampireLevelingConf {
    private static final VampireLevelingConf instance = new VampireLevelingConf();
    private final int INSPIRATION_MIN_LEVEL;
    private final int INSPIRATION_MAX_LEVEL;
    private final int INFUSION_MAX_LEVEL;
    private final int INFUSION_MIN_LEVEL;
    private final Map<Integer, AltarInfusionRequirements> altarInfusionRequirementsHashMap = Maps.newHashMap();

    public static VampireLevelingConf getInstance() {
        return instance;
    }

    private VampireLevelingConf() {
        this.INSPIRATION_MIN_LEVEL = 2;
        this.INSPIRATION_MAX_LEVEL = 4;
        this.INFUSION_MIN_LEVEL = 5;
        this.INFUSION_MAX_LEVEL = 14;
        this.altarInfusionRequirementsHashMap.put(5, new AltarInfusionRequirements(0, 0, 5, 1));
        this.altarInfusionRequirementsHashMap.put(6, new AltarInfusionRequirements(0, 1, 5, 1));
        this.altarInfusionRequirementsHashMap.put(7, new AltarInfusionRequirements(0, 1, 10, 1));
        this.altarInfusionRequirementsHashMap.put(8, new AltarInfusionRequirements(1, 1, 10, 1));
        this.altarInfusionRequirementsHashMap.put(9, new AltarInfusionRequirements(1, 1, 10, 1));
        this.altarInfusionRequirementsHashMap.put(10, new AltarInfusionRequirements(2, 1, 15, 1));
        this.altarInfusionRequirementsHashMap.put(11, new AltarInfusionRequirements(2, 1, 15, 1));
        this.altarInfusionRequirementsHashMap.put(12, new AltarInfusionRequirements(3, 1, 20, 1));
        this.altarInfusionRequirementsHashMap.put(13, new AltarInfusionRequirements(3, 2, 20, 1));
        this.altarInfusionRequirementsHashMap.put(14, new AltarInfusionRequirements(4, 2, 25, 1));
        assert (this.altarInfusionRequirementsHashMap.size() == this.INFUSION_MAX_LEVEL - this.INFUSION_MIN_LEVEL + 1);
    }

    @Nonnull
    public AltarInfusionRequirements getAltarInfusionRequirements(int targetLevel) {
        if (!this.altarInfusionRequirementsHashMap.containsKey(targetLevel)) {
            throw new IllegalArgumentException("Level " + targetLevel + " cannot be reached with an altar of infusion");
        }
        return this.altarInfusionRequirementsHashMap.get(targetLevel);
    }

    public int getRequiredBloodForAltarInspiration(int targetLevel) {
        if (!this.isLevelValidForAltarInspiration(targetLevel)) {
            return -1;
        }
        return 40 + (targetLevel - this.INSPIRATION_MIN_LEVEL) * 30;
    }

    public int getRequiredStructureLevelAltarInfusion(int targetLevel) {
        int t = (targetLevel - 4) / 2;
        return (int)(8.0f + (float)(46 * t) / 5.0f);
    }

    public boolean isLevelValidForAltarInfusion(int targetLevel) {
        return targetLevel >= this.INFUSION_MIN_LEVEL && targetLevel <= this.INFUSION_MAX_LEVEL;
    }

    public boolean isLevelValidForAltarInspiration(int targetLevel) {
        return targetLevel >= this.INSPIRATION_MIN_LEVEL && targetLevel <= this.INSPIRATION_MAX_LEVEL;
    }

    public static class AltarInfusionRequirements {
        public final int blood;
        public final int heart;
        public final int vampireBook;
        public final int pureBloodLevel;

        AltarInfusionRequirements(int pureBloodLevel, int blood, int heart, int vampireBook) {
            this.blood = blood;
            this.heart = heart;
            this.vampireBook = vampireBook;
            this.pureBloodLevel = pureBloodLevel;
        }
    }
}

