/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class DarkBloodProjectileAction
extends DefaultVampireAction {
    @Override
    public int getCooldown() {
        return (Integer)VampirismConfig.BALANCE.vaDarkBloodProjectileCooldown.get() * 20;
    }

    @Override
    public int getCooldown(IFactionPlayer player) {
        int cooldown = (Integer)VampirismConfig.BALANCE.vaDarkBloodProjectileCooldown.get() * 20;
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_AOE.get())) {
            cooldown = (int)((double)cooldown * (Double)VampirismConfig.BALANCE.vrDarkBloodProjectileAOECooldownMod.get());
        }
        return cooldown;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaDarkBloodProjectileEnabled.get();
    }

    @Override
    public boolean showHudCooldown(PlayerEntity player) {
        return true;
    }

    @Override
    protected boolean activate(IVampirePlayer player) {
        PlayerEntity shooter = player.getRepresentingPlayer();
        float directDamage = ((Double)VampirismConfig.BALANCE.vaDarkBloodProjectileDamage.get()).floatValue();
        float indirectDamage = directDamage * 0.5f;
        float speed = 0.95f;
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_DAMAGE.get())) {
            float modifier = ((Double)VampirismConfig.BALANCE.vrDarkBloodProjectileDamageMod.get()).floatValue();
            directDamage *= modifier;
            indirectDamage *= modifier;
        }
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_SPEED.get())) {
            speed = 1.4f;
        }
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_AOE.get())) {
            for (int i = 0; i < 32; ++i) {
                Vector3d vec3d = this.getRotationVector(shooter.func_195050_f(1.0f), shooter.func_195046_g(1.0f) + (float)i * 11.25f);
                DarkBloodProjectileEntity entity = this.createProjectile(shooter, shooter.func_213303_ch(), 0.0, vec3d, false, 0.0f, 0.0f, 0.95f);
                entity.setMaxTicks(7);
                entity.excludeShooter();
                if (i != 0) continue;
                entity.setDamage(0.0f, directDamage);
                entity.explode((Integer)VampirismConfig.BALANCE.vrDarkBloodProjectileAOERange.get(), null);
            }
        } else {
            boolean goThrough = player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION.get());
            this.createProjectile(shooter, shooter.func_213303_ch(), shooter.func_70047_e() * 0.9f, shooter.func_70676_i(1.0f), goThrough, directDamage, indirectDamage, speed);
            if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT.get())) {
                this.createProjectile(shooter, shooter.func_213303_ch(), shooter.func_70047_e() * 0.9f, this.getVectorForRotation(shooter.func_195050_f(1.0f), shooter.func_195046_g(1.0f) + 30.0f), goThrough, directDamage, indirectDamage, speed);
                this.createProjectile(shooter, shooter.func_213303_ch(), shooter.func_70047_e() * 0.9f, this.getVectorForRotation(shooter.func_195050_f(1.0f), shooter.func_195046_g(1.0f) - 30.0f), goThrough, directDamage, indirectDamage, speed);
            }
        }
        return true;
    }

    private DarkBloodProjectileEntity createProjectile(PlayerEntity shooter, Vector3d position, double height, Vector3d direction, boolean goThrough, float directDamage, float indirectDamage, float speed) {
        DarkBloodProjectileEntity entity = new DarkBloodProjectileEntity(shooter.func_130014_f_(), position.field_72450_a + direction.field_72450_a, position.field_72448_b + height, position.field_72449_c + direction.field_72449_c, direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
        entity.setMotionFactor(speed);
        entity.func_212361_a((Entity)shooter);
        entity.setDamage(directDamage, indirectDamage);
        if (goThrough) {
            entity.setGothrough(true);
        }
        shooter.func_130014_f_().func_217376_c((Entity)entity);
        return entity;
    }

    private Vector3d getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        return new Vector3d((double)(f3 * f4), 0.0, (double)(f2 * f4));
    }

    private Vector3d getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vector3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }
}

