/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraftforge.common.ForgeMod;

public class InfectAction
extends DefaultVampireAction {
    @Override
    public int getCooldown() {
        return 10;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean canBeUsedBy(IVampirePlayer player) {
        if (player.getRepresentingPlayer().field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        if (player.isRemote()) {
            Entity target = VampirismMod.proxy.getMouseOverEntity();
            if (target != null && (!(target instanceof PlayerEntity) && !(target instanceof VillagerEntity) || !UtilLib.canReallySee((LivingEntity)target, (LivingEntity)player.getRepresentingPlayer(), false)) && (double)player.getRepresentingPlayer().func_70032_d(target) <= player.getRepresentingPlayer().func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() / 2.0 + 1.0) {
                return this.deriveBiteableEntry(target).map(b -> b.canBeInfected(player)).orElse(false);
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean activate(IVampirePlayer vampire, IAction.ActivationContext context) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        Entity creature = context.targetEntity().filter(LivingEntity.class::isInstance).filter(target -> {
            if ((target instanceof PlayerEntity || target instanceof VillagerEntity) && UtilLib.canReallySee((LivingEntity)target, (LivingEntity)player, false)) {
                return false;
            }
            if ((double)player.func_70032_d(target) <= player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() / 2.0 + 1.0) {
                return this.deriveBiteableEntry((Entity)target).map(e -> e.tryInfect(vampire)).orElse(false);
            }
            return false;
        }).orElse(null);
        if (creature != null) {
            player.func_195066_a(ModStats.infected_creatures);
            player.field_70170_p.func_184148_a(null, creature.func_226277_ct_(), creature.func_226278_cu_() + 1.5, creature.func_226281_cx_(), (SoundEvent)ModSounds.PLAYER_BITE.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        } else {
            player.field_70170_p.func_184148_a(null, vampire.getRepresentingPlayer().func_226277_ct_(), vampire.getRepresentingPlayer().func_226278_cu_() + 1.5, vampire.getRepresentingPlayer().func_226281_cx_(), SoundEvents.field_219665_hd, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return creature != null;
    }

    private Optional<? extends IBiteableEntity> deriveBiteableEntry(Entity target) {
        if (target instanceof IBiteableEntity) {
            return Optional.of((IBiteableEntity)target);
        }
        if (target instanceof CreatureEntity) {
            return ExtendedCreature.getSafe(target).resolve();
        }
        if (target instanceof PlayerEntity) {
            return VampirePlayer.getOpt((PlayerEntity)target).resolve();
        }
        return Optional.empty();
    }
}

