/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.vampirism.blocks.AlchemyTableBlock;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.container.AlchemyTableContainer;
import de.teamlapen.vampirism.inventory.recipes.AbstractBrewingRecipe;
import de.teamlapen.vampirism.util.OilUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class AlchemyTableTileEntity
extends LockableTileEntity
implements ITickableTileEntity {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private int brewTime;
    private boolean[] lastOilCount;
    private Item ingredient;
    private int fuel;
    private int productColor;
    protected final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int slotId) {
            switch (slotId) {
                case 0: {
                    return AlchemyTableTileEntity.this.brewTime;
                }
                case 1: {
                    return AlchemyTableTileEntity.this.fuel;
                }
                case 2: {
                    return AlchemyTableTileEntity.this.productColor;
                }
            }
            return 0;
        }

        public void func_221477_a(int slotId, int value) {
            switch (slotId) {
                case 0: {
                    AlchemyTableTileEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    AlchemyTableTileEntity.this.fuel = value;
                    break;
                }
                case 2: {
                    AlchemyTableTileEntity.this.productColor = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public AlchemyTableTileEntity() {
        super((TileEntityType)ModTiles.ALCHEMICAL_TABLE.get());
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.vampirism.alchemy_table");
    }

    @Nonnull
    protected Container func_213906_a(int menuId, @Nonnull PlayerInventory playerInventory) {
        return new AlchemyTableContainer(menuId, this.field_145850_b, playerInventory, (IInventory)this, this.dataAccess);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean[] getPotionBits() {
        boolean[] aboolean = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    @Nonnull
    public ItemStack func_70301_a(int p_70301_1_) {
        return p_70301_1_ >= 0 && p_70301_1_ < this.items.size() ? (ItemStack)this.items.get(p_70301_1_) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return ItemStackHelper.func_188382_a(this.items, (int)p_70298_1_, (int)p_70298_2_);
    }

    @Nonnull
    public ItemStack func_70304_b(int p_70304_1_) {
        return ItemStackHelper.func_188383_a(this.items, (int)p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, @Nonnull ItemStack stack) {
        if (p_70299_1_ >= 0 && p_70299_1_ < this.items.size()) {
            this.items.set(p_70299_1_, (Object)stack);
        }
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_73660_a() {
        boolean[] aboolean;
        ItemStack itemstack = (ItemStack)this.items.get(5);
        if (this.fuel <= 0 && itemstack.func_77973_b() == Items.field_151065_br) {
            this.fuel = 20;
            itemstack.func_190918_g(1);
            this.func_70296_d();
        }
        boolean flag = this.isBrewable();
        boolean flag1 = this.brewTime > 0;
        ItemStack itemstack1 = (ItemStack)this.items.get(4);
        if (flag1) {
            boolean flag2;
            --this.brewTime;
            boolean bl = flag2 = this.brewTime == 0;
            if (flag2 && flag) {
                this.doBrew();
                this.func_70296_d();
            } else if (!flag) {
                this.brewTime = 0;
                this.func_70296_d();
            } else if (this.ingredient != itemstack1.func_77973_b()) {
                this.brewTime = 0;
                this.func_70296_d();
            }
        } else if (flag && this.fuel > 0) {
            --this.fuel;
            this.brewTime = 600;
            this.ingredient = itemstack1.func_77973_b();
            this.productColor = this.field_145850_b.func_199532_z().func_241447_a_(ModRecipes.ALCHEMICAL_TABLE_TYPE).stream().filter(recipe -> recipe.isInput((ItemStack)this.items.get(4)) && (recipe.isIngredient((ItemStack)this.items.get(0)) || recipe.isIngredient((ItemStack)this.items.get(1)))).map(AbstractBrewingRecipe::func_77571_b).map(s -> OilUtils.getOil(s).getColor()).findAny().orElse(0xFFFFFF);
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K && !Arrays.equals(aboolean = this.getPotionBits(), this.lastOilCount)) {
            this.lastOilCount = aboolean;
            BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (!(blockstate.func_177230_c() instanceof AlchemyTableBlock)) {
                return;
            }
            blockstate = (BlockState)blockstate.func_206870_a((Property)AlchemyTableBlock.HAS_BOTTLE_INPUT_0, (Comparable)Boolean.valueOf(aboolean[0]));
            blockstate = (BlockState)blockstate.func_206870_a((Property)AlchemyTableBlock.HAS_BOTTLE_INPUT_1, (Comparable)Boolean.valueOf(aboolean[1]));
            blockstate = (BlockState)blockstate.func_206870_a((Property)AlchemyTableBlock.HAS_BOTTLE_OUTPUT_0, (Comparable)Boolean.valueOf(aboolean[2]));
            blockstate = (BlockState)blockstate.func_206870_a((Property)AlchemyTableBlock.HAS_BOTTLE_OUTPUT_1, (Comparable)Boolean.valueOf(aboolean[3]));
            this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 2);
        }
    }

    private boolean isIngredient(ItemStack stack) {
        return this.field_145850_b.func_199532_z().func_241447_a_(ModRecipes.ALCHEMICAL_TABLE_TYPE).stream().anyMatch(recipe -> recipe.isIngredient(stack));
    }

    private boolean isInput(ItemStack stack) {
        return this.field_145850_b.func_199532_z().func_241447_a_(ModRecipes.ALCHEMICAL_TABLE_TYPE).stream().anyMatch(recipe -> recipe.isInput(stack));
    }

    private boolean hasRecipe(ItemStack input, ItemStack ingredient) {
        return this.field_145850_b.func_199532_z().func_241447_a_(ModRecipes.ALCHEMICAL_TABLE_TYPE).stream().anyMatch(recipe -> recipe.isInput(input) && recipe.isIngredient(ingredient));
    }

    private boolean isBrewable() {
        ItemStack itemstack = (ItemStack)this.items.get(4);
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (!this.isInput(itemstack)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack itemstack1;
            if (!((ItemStack)this.items.get(i + 2)).func_190926_b() || (itemstack1 = (ItemStack)this.items.get(i)).func_190926_b() || !this.hasRecipe(itemstack, itemstack1)) continue;
            return true;
        }
        return false;
    }

    private void doBrew() {
        ItemStack itemstack = (ItemStack)this.items.get(4);
        for (int i = 0; i < 2; ++i) {
            if (!((ItemStack)this.items.get(i + 2)).func_190926_b()) continue;
            ItemStack stack = this.getOutput(itemstack, (ItemStack)this.items.get(i));
            this.items.set(i, (Object)ItemStack.field_190927_a);
            this.items.set(i + 2, (Object)stack);
        }
        BlockPos blockpos = this.func_174877_v();
        if (itemstack.hasContainerItem()) {
            ItemStack itemstack1 = itemstack.getContainerItem();
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                itemstack = itemstack1;
            } else if (!this.field_145850_b.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (ItemStack)itemstack1);
            }
        } else {
            itemstack.func_190918_g(1);
        }
        this.items.set(4, (Object)itemstack);
        this.field_145850_b.func_217379_c(1035, blockpos, 0);
    }

    public boolean func_94041_b(int p_94041_1_, @Nonnull ItemStack stack) {
        if (p_94041_1_ == 3) {
            return this.isValidIngredient(stack);
        }
        Item item = stack.func_77973_b();
        if (p_94041_1_ == 4) {
            return item == Items.field_151065_br;
        }
        return this.isValidInput(stack) && this.func_70301_a(p_94041_1_).func_190926_b();
    }

    public boolean isValidIngredient(ItemStack stack) {
        return this.field_145850_b.func_199532_z().func_241447_a_(ModRecipes.ALCHEMICAL_TABLE_TYPE).stream().anyMatch(recipe -> recipe.isIngredient(stack));
    }

    public boolean isValidInput(ItemStack stack) {
        return this.field_145850_b.func_199532_z().func_241447_a_(ModRecipes.ALCHEMICAL_TABLE_TYPE).stream().anyMatch(recipe -> recipe.isInput(stack));
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        return this.field_145850_b.func_199532_z().func_241447_a_(ModRecipes.ALCHEMICAL_TABLE_TYPE).stream().map(recipe -> recipe.getResult(input, ingredient)).filter(a -> !a.func_190926_b()).findFirst().orElse(ItemStack.field_190927_a);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        this.brewTime = compound.func_74765_d("BrewTime");
        this.fuel = compound.func_74771_c("Fuel");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("BrewTime", (short)this.brewTime);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        compound.func_74774_a("Fuel", (byte)this.fuel);
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        return super.func_189517_E_();
    }
}

