/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.blocks.GarlicBeaconBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GarlicBeaconTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int FUEL_DURATION = 2400;
    private int id;
    private EnumStrength strength = EnumStrength.MEDIUM;
    private EnumStrength defaultStrength = EnumStrength.MEDIUM;
    private int r = 1;
    private boolean registered = false;
    private int fueled = 0;
    private int bootTimer;
    private int maxBootTimer;

    public GarlicBeaconTileEntity() {
        super((TileEntityType)ModTiles.GARLIC_BEACON.get());
    }

    public float getBootProgress() {
        return this.bootTimer > 0 ? 1.0f - (float)this.bootTimer / (float)this.maxBootTimer : 1.0f;
    }

    public int getFuelTime() {
        return this.fueled;
    }

    public float getFueledState() {
        return (float)this.fueled / 2400.0f;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.isActive()) {
            this.register();
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public boolean isActive() {
        return this.bootTimer == 0;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean isInRange(BlockPos pos) {
        return new ChunkPos(this.func_174877_v()).func_226661_a_(new ChunkPos(pos)) <= this.r;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.r = compound.func_74762_e("radius");
        this.defaultStrength = EnumStrength.getFromStrenght(compound.func_74762_e("strength"));
        this.bootTimer = compound.func_74762_e("boot_timer");
        this.setFueledTime(compound.func_74762_e("fueled"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.func_145830_o()) {
            CompoundNBT nbt = pkt.func_148857_g();
            this.handleUpdateTag(this.field_145850_b.func_180495_p(pkt.func_179823_a()), nbt);
            if (this.isActive()) {
                this.register();
            }
        }
    }

    public void onTouched(PlayerEntity player) {
        if (VampirismPlayerAttributes.get((PlayerEntity)player).vampireLevel > 0) {
            VampirePlayer.getOpt(player).ifPresent(vampirePlayer -> DamageHandler.affectVampireGarlicDirect(vampirePlayer, this.strength));
        }
    }

    public void onFueled() {
        this.setFueledTime(2400);
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("radius", this.r);
        compound.func_74768_a("strength", this.defaultStrength.getStrength());
        compound.func_74768_a("fueled", this.fueled);
        if (this.bootTimer != 0) {
            compound.func_74768_a("boot_timer", this.bootTimer);
        }
        return compound;
    }

    public void setNewBootDelay(int delayTicks) {
        this.bootTimer = delayTicks;
        this.maxBootTimer = delayTicks;
    }

    public void setType(GarlicBeaconBlock.Type type) {
        switch (type) {
            case WEAK: {
                this.r = (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorWeakDist.get();
                this.defaultStrength = EnumStrength.WEAK;
                break;
            }
            case NORMAL: {
                this.r = (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorNormalDist.get();
                this.defaultStrength = EnumStrength.MEDIUM;
                break;
            }
            case IMPROVED: {
                this.defaultStrength = EnumStrength.MEDIUM;
                this.r = (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorEnhancedDist.get();
            }
        }
        this.strength = this.defaultStrength;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145830_o()) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.unregister();
    }

    public void func_73660_a() {
        if (this.bootTimer > 0) {
            if (--this.bootTimer == 0) {
                this.func_70296_d();
                this.register();
            }
        } else if (this.fueled > 0) {
            if (this.fueled == 1) {
                this.setFueledTime(0);
                this.func_70296_d();
            } else {
                --this.fueled;
            }
        }
    }

    private void register() {
        if (this.registered || !this.func_145830_o()) {
            return;
        }
        int baseX = this.func_174877_v().func_177958_n() >> 4;
        int baseZ = this.func_174877_v().func_177952_p() >> 4;
        ChunkPos[] chunks = new ChunkPos[(2 * this.r + 1) * (2 * this.r + 1)];
        int i = 0;
        for (int x = -this.r; x <= this.r; ++x) {
            for (int z = -this.r; z <= this.r; ++z) {
                chunks[i++] = new ChunkPos(x + baseX, z + baseZ);
            }
        }
        this.id = VampirismAPI.getVampirismWorld(this.func_145831_w()).map(vw -> vw.registerGarlicBlock(this.strength, chunks)).orElse(0);
        this.registered = i != 0;
    }

    private void setFueledTime(int time) {
        int old = this.fueled;
        this.fueled = time;
        this.strength = this.fueled > 0 ? EnumStrength.STRONG : this.defaultStrength;
        if ((time > 0 && old == 0 || time == 0 && old > 0) && !this.func_145837_r()) {
            this.unregister();
            this.register();
        }
    }

    private void unregister() {
        if (this.registered && this.func_145830_o()) {
            VampirismAPI.getVampirismWorld(this.func_145831_w()).ifPresent(vw -> vw.removeGarlicBlock(this.id));
            this.registered = false;
        }
    }
}

