/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class PedestalTileEntity
extends TileEntity
implements ITickableTileEntity,
IItemHandler {
    private final Random rand = new Random();
    private final LazyOptional<IItemHandler> opt = LazyOptional.of(() -> this);
    private final int chargeRate = 30;
    private int ticksExistedClient;
    private int chargingTicks;
    private int bloodStored = 0;
    @Nonnull
    private ItemStack internalStack = ItemStack.field_190927_a;

    public PedestalTileEntity() {
        super((TileEntityType)ModTiles.BLOOD_PEDESTAL.get());
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.internalStack;
        if (slot == 0 && !stack.func_190926_b()) {
            if (!simulate) {
                this.removeStack();
                this.markDirtyAndUpdateClient();
            }
            return simulate ? stack.func_77946_l() : stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != Direction.DOWN) {
            return this.opt.cast();
        }
        return super.getCapability(capability, facing);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackForRender() {
        return this.internalStack;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.internalStack : ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTickForRender() {
        return this.ticksExistedClient;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean hasStack() {
        return !this.internalStack.func_190926_b();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot == 0 && this.internalStack.func_190926_b()) {
            if (!simulate) {
                this.setStack(stack);
                this.markDirtyAndUpdateClient();
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.internalStack = compound.func_74764_b("item") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("item")) : ItemStack.field_190927_a;
        this.bloodStored = compound.func_74762_e("blood_stored");
        this.chargingTicks = compound.func_74762_e("charging_ticks");
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.func_145830_o()) {
            this.handleUpdateTag(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
        }
    }

    @Nonnull
    public ItemStack removeStack() {
        ItemStack stack = this.internalStack;
        this.internalStack = ItemStack.field_190927_a;
        return stack;
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.hasStack()) {
            compound.func_218657_a("item", (INBT)this.internalStack.serializeNBT());
        }
        compound.func_74768_a("blood_stored", this.bloodStored);
        compound.func_74768_a("charging_ticks", this.chargingTicks);
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.chargingTicks > 0) {
                --this.chargingTicks;
                if (this.chargingTicks == 0) {
                    IBloodChargeable chargeable = this.getChargeItem(this.internalStack);
                    if (chargeable != null && this.bloodStored > 0) {
                        int charged = chargeable.charge(this.internalStack, this.bloodStored);
                        this.bloodStored -= Math.max(0, charged);
                    }
                    this.markDirtyAndUpdateClient();
                }
            } else if (this.chargingTicks == 0) {
                IBloodChargeable chargeable = this.getChargeItem(this.internalStack);
                if (chargeable != null && chargeable.canBeCharged(this.internalStack)) {
                    if (this.bloodStored < 30) {
                        this.drainBlood();
                    }
                    if (this.bloodStored > 0) {
                        this.chargingTicks = 20;
                        this.markDirtyAndUpdateClient();
                    } else {
                        this.chargingTicks = -40;
                    }
                } else {
                    this.chargingTicks = -40;
                }
            } else {
                ++this.chargingTicks;
            }
        } else {
            ++this.ticksExistedClient;
            if (this.chargingTicks > 0 && this.ticksExistedClient % 8 == 0) {
                this.spawnChargedParticle();
            }
        }
    }

    private void drainBlood() {
        if (this.field_145850_b == null) {
            return;
        }
        FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP).ifPresent(handler -> {
            FluidStack drained = handler.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), 100), IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty() && drained.getAmount() == 100) {
                drained = handler.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), 100), IFluidHandler.FluidAction.EXECUTE);
                this.bloodStored += drained.getAmount();
            }
        });
    }

    @Nullable
    private IBloodChargeable getChargeItem(@Nonnull ItemStack stack) {
        return stack.func_190926_b() ? null : (stack.func_77973_b() instanceof IBloodChargeable ? (IBloodChargeable)stack.func_77973_b() : null);
    }

    private void markDirtyAndUpdateClient() {
        if (this.field_145850_b != null) {
            super.func_70296_d();
            BlockState block = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, block, block, 3);
        }
    }

    private void setStack(@Nonnull ItemStack stack) {
        this.chargingTicks = 0;
        if (this.internalStack.func_190926_b()) {
            this.internalStack = stack;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnChargedParticle() {
        Vector3d pos = Vector3d.func_237490_a_((Vector3i)this.func_174877_v(), (double)0.8);
        ModParticles.spawnParticleClient(this.func_145831_w(), new FlyingBloodParticleData((ParticleType<FlyingBloodParticleData>)((ParticleType)ModParticles.FLYING_BLOOD.get()), (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f)), true, pos.field_72450_a + (double)(1.0f - this.rand.nextFloat()) * 0.1, pos.field_72448_b + (double)(1.0f - this.rand.nextFloat()) * 0.2, pos.field_72449_c + (double)(1.0f - this.rand.nextFloat()) * 0.1, new ResourceLocation("minecraft", "glitter_1")), (double)this.field_174879_c.func_177958_n() + 0.2, (double)this.func_174877_v().func_177956_o() + 0.65, (double)this.func_174877_v().func_177952_p() + 0.2);
        ModParticles.spawnParticleClient(this.func_145831_w(), new FlyingBloodParticleData((ParticleType<FlyingBloodParticleData>)((ParticleType)ModParticles.FLYING_BLOOD.get()), (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f)), true, pos.field_72450_a + (double)(1.0f - this.rand.nextFloat()) * 0.1, pos.field_72448_b + (double)(1.0f - this.rand.nextFloat()) * 0.2, pos.field_72449_c + (double)(1.0f - this.rand.nextFloat()) * 0.1, new ResourceLocation("minecraft", "glitter_1")), (double)this.field_174879_c.func_177958_n() + 0.8, (double)this.func_174877_v().func_177956_o() + 0.65, (double)this.func_174877_v().func_177952_p() + 0.2);
        ModParticles.spawnParticleClient(this.func_145831_w(), new FlyingBloodParticleData((ParticleType<FlyingBloodParticleData>)((ParticleType)ModParticles.FLYING_BLOOD.get()), (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f)), true, pos.field_72450_a + (double)(1.0f - this.rand.nextFloat()) * 0.1, pos.field_72448_b + (double)(1.0f - this.rand.nextFloat()) * 0.2, pos.field_72449_c + (double)(1.0f - this.rand.nextFloat()) * 0.1, new ResourceLocation("minecraft", "glitter_1")), (double)this.field_174879_c.func_177958_n() + 0.2, (double)this.func_174877_v().func_177956_o() + 0.65, (double)this.func_174877_v().func_177952_p() + 0.8);
        ModParticles.spawnParticleClient(this.func_145831_w(), new FlyingBloodParticleData((ParticleType<FlyingBloodParticleData>)((ParticleType)ModParticles.FLYING_BLOOD.get()), (int)(3.0f / (this.rand.nextFloat() * 0.6f + 0.4f)), true, pos.field_72450_a + (double)(1.0f - this.rand.nextFloat()) * 0.1, pos.field_72448_b + (double)(1.0f - this.rand.nextFloat()) * 0.2, pos.field_72449_c + (double)(1.0f - this.rand.nextFloat()) * 0.1, new ResourceLocation("minecraft", "glitter_1")), (double)this.field_174879_c.func_177958_n() + 0.8, (double)this.func_174877_v().func_177956_o() + 0.65, (double)this.func_174877_v().func_177952_p() + 0.8);
    }
}

