/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import de.teamlapen.vampirism.world.FactionPointOfInterestType;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TotemHelper {
    public static final int MIN_HOMES = 4;
    public static final int MIN_WORKSTATIONS = 2;
    public static final int MIN_VILLAGER = 4;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<RegistryKey<World>, Map<BlockPos, BlockPos>> totemPositions = Maps.newHashMap();
    private static final Map<RegistryKey<World>, Map<BlockPos, Set<PointOfInterest>>> poiSets = Maps.newHashMap();

    @Deprecated
    public static void addVampireVillage(RegistryKey<World> dimension, BlockPos pos, AxisAlignedBB box) {
        World w = VampLib.proxy.getWorldFromKey(dimension);
        if (w != null) {
            VampirismWorld.getOpt(w).ifPresent(vw -> vw.updateArtificialFogBoundingBox(pos, box));
        }
    }

    @Deprecated
    public static void removeVampireVillage(RegistryKey<World> dimension, BlockPos pos) {
        World w = VampLib.proxy.getWorldFromKey(dimension);
        if (w != null) {
            VampirismWorld.getOpt(w).ifPresent(vw -> vw.updateArtificialFogBoundingBox(pos, null));
        }
    }

    @Deprecated
    public static boolean isInsideVampireAreaCached(RegistryKey<World> dimension, BlockPos blockPos) {
        World w = VampLib.proxy.getWorldFromKey(dimension);
        if (w != null) {
            return VampirismWorld.getOpt(w).map(vw -> vw.isInsideArtificialVampireFogArea(blockPos)).orElse(false);
        }
        return false;
    }

    public static boolean addTotem(ServerWorld world, Set<PointOfInterest> pois, BlockPos totemPos) {
        BlockPos conflict = null;
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent((RegistryKey<World>)world.func_234923_W_(), key -> new HashMap());
        for (PointOfInterest poi2 : pois) {
            if (!totemPositions.containsKey(poi2.func_218261_f()) || ((BlockPos)totemPositions.get(poi2.func_218261_f())).equals((Object)totemPos)) continue;
            conflict = (BlockPos)totemPositions.get(poi2.func_218261_f());
            break;
        }
        if (conflict != null) {
            TotemHelper.handleTotemConflict(pois, world, totemPos, conflict);
        }
        if (pois.isEmpty()) {
            return false;
        }
        for (PointOfInterest pointOfInterest : pois) {
            totemPositions.put(pointOfInterest.func_218261_f(), totemPos);
        }
        totemPositions.put(totemPos, totemPos);
        Map poiSets = TotemHelper.poiSets.computeIfAbsent((RegistryKey<World>)world.func_234923_W_(), key -> new HashMap());
        if (poiSets.containsKey(totemPos)) {
            ((Set)poiSets.get(totemPos)).forEach(poi -> {
                if (!pois.contains(poi)) {
                    totemPositions.remove(poi.func_218261_f());
                }
            });
        }
        poiSets.put(totemPos, pois);
        return !pois.isEmpty();
    }

    private static void handleTotemConflict(Set<PointOfInterest> pois, ServerWorld world, BlockPos totem, BlockPos conflicting) {
        boolean ignoreOtherTotem;
        TotemTileEntity totem1 = (TotemTileEntity)world.func_175625_s(totem);
        TotemTileEntity totem2 = (TotemTileEntity)world.func_175625_s(conflicting);
        if (totem2 == null) {
            return;
        }
        boolean bl = ignoreOtherTotem = totem1.getControllingFaction() == totem2.getControllingFaction();
        if (totem1.getCapturingFaction() != null || totem2.getCapturingFaction() != null) {
            ignoreOtherTotem = false;
        }
        StructureStart<?> structure1 = UtilLib.getStructureStartAt(world, totem, Structure.field_236381_q_);
        StructureStart<?> structure2 = UtilLib.getStructureStartAt(world, conflicting, Structure.field_236381_q_);
        if ((structure1 == StructureStart.field_214630_a || !structure1.func_75069_d()) && structure2 != StructureStart.field_214630_a && structure2.func_75069_d()) {
            ignoreOtherTotem = false;
        }
        if (totem2.getSize() >= totem1.getSize()) {
            ignoreOtherTotem = false;
        }
        if (!ignoreOtherTotem) {
            pois.removeIf(poi -> !totem.equals((Object)totemPositions.get(world.func_234923_W_()).get(poi.func_218261_f())));
        }
    }

    public static void removeTotem(RegistryKey<World> dimension, Collection<PointOfInterest> pois, BlockPos pos, boolean removeTotem) {
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent(dimension, key -> new HashMap());
        pois.forEach(pointOfInterest -> totemPositions.remove(pointOfInterest.func_218261_f(), pos));
        if (removeTotem) {
            totemPositions.remove(pos);
        }
    }

    @Deprecated
    public static void removeTotem(Collection<PointOfInterest> pois, BlockPos pos, boolean removeTotem) {
        TotemHelper.removeTotem((RegistryKey<World>)World.field_234918_g_, pois, pos, removeTotem);
    }

    @Deprecated
    public static void removeTotem(Collection<PointOfInterest> pois, BlockPos pos) {
        TotemHelper.removeTotem(pois, pos, true);
    }

    @Nonnull
    public static Optional<BlockPos> getTotemPosition(RegistryKey<World> dimension, Collection<PointOfInterest> pois) {
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent(dimension, key -> new HashMap());
        for (PointOfInterest pointOfInterest : pois) {
            if (!totemPositions.containsKey(pointOfInterest.func_218261_f())) continue;
            return Optional.of(totemPositions.get(pointOfInterest.func_218261_f()));
        }
        return Optional.empty();
    }

    @Deprecated
    @Nonnull
    public static Optional<BlockPos> getTotemPosition(Collection<PointOfInterest> pois) {
        return TotemHelper.getTotemPosition((RegistryKey<World>)World.field_234918_g_, pois);
    }

    @Nullable
    public static BlockPos getTotemPosition(RegistryKey<World> world, BlockPos pos) {
        if (totemPositions.containsKey(world)) {
            return totemPositions.get(world).get(pos);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static BlockPos getTotemPosition(BlockPos pos) {
        return TotemHelper.getTotemPosition((RegistryKey<World>)World.field_234918_g_, pos);
    }

    @Nonnull
    public static Optional<BlockPos> getTotemPosNearPos(ServerWorld world, BlockPos pos) {
        Collection points = world.func_217443_B().func_219146_b(p -> true, pos, 25, PointOfInterestManager.Status.ANY).collect(Collectors.toList());
        if (!points.isEmpty()) {
            return TotemHelper.getTotemPosition((RegistryKey<World>)world.func_234923_W_(), points);
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<TotemTileEntity> getTotemNearPos(ServerWorld world, BlockPos posSource, boolean mustBeLoaded) {
        Optional<BlockPos> posOpt = TotemHelper.getTotemPosNearPos(world, posSource);
        if (mustBeLoaded) {
            posOpt = posOpt.filter(pos -> world.func_72863_F().func_222865_a(new ChunkPos(pos)));
        }
        return posOpt.map(pos -> {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TotemTileEntity) {
                return (TotemTileEntity)tile;
            }
            return null;
        });
    }

    public static ITextComponent forceFactionCommand(IFaction<?> faction, ServerPlayerEntity player) {
        Map totemPositions = TotemHelper.totemPositions.computeIfAbsent((RegistryKey<World>)player.func_130014_f_().func_234923_W_(), key -> new HashMap());
        List pointOfInterests = ((ServerWorld)player.func_130014_f_()).func_217443_B().func_219146_b(point -> true, player.func_233580_cy_(), 25, PointOfInterestManager.Status.ANY).sorted(Comparator.comparingInt(point -> (int)point.func_218261_f().func_177951_i((Vector3i)player.func_233580_cy_()))).collect(Collectors.toList());
        if (pointOfInterests.stream().noneMatch(point -> totemPositions.containsKey(point.func_218261_f()))) {
            return new TranslationTextComponent("command.vampirism.test.village.no_village");
        }
        TileEntity te = player.func_130014_f_().func_175625_s((BlockPos)totemPositions.get(((PointOfInterest)pointOfInterests.get(0)).func_218261_f()));
        if (!(te instanceof TotemTileEntity)) {
            LOGGER.warn("TileEntity at {} is no TotemTileEntity", totemPositions.get(((PointOfInterest)pointOfInterests.get(0)).func_218261_f()));
            return new StringTextComponent("");
        }
        TotemTileEntity tile = (TotemTileEntity)te;
        tile.setForcedFaction(faction);
        return new TranslationTextComponent("command.vampirism.test.village.success", new Object[]{faction == null ? "none" : faction.getName()});
    }

    public static Set<PointOfInterest> getVillagePointsOfInterest(ServerWorld world, BlockPos pos) {
        PointOfInterestManager manager = world.func_217443_B();
        HashSet finished = Sets.newHashSet();
        Set points = manager.func_219146_b(type -> !(type instanceof FactionPointOfInterestType), pos, 50, PointOfInterestManager.Status.ANY).collect(Collectors.toSet());
        while (!points.isEmpty()) {
            List<Stream> list = points.stream().map(pointOfInterest -> manager.func_219146_b(type -> !(type instanceof FactionPointOfInterestType), pointOfInterest.func_218261_f(), 40, PointOfInterestManager.Status.ANY)).collect(Collectors.toList());
            points.clear();
            list.forEach(stream -> stream.forEach(point -> {
                if (!finished.contains(point) && point.func_218261_f().func_218141_a((Vector3i)pos, (double)((Integer)VampirismConfig.BALANCE.viMaxTotemRadius.get()).intValue())) {
                    points.add(point);
                }
                finished.add(point);
            }));
        }
        return finished;
    }

    public static int isVillage(Map<Integer, Integer> stats, boolean hasInteraction) {
        int status = 0;
        if (stats.get(1) >= 4) {
            ++status;
        }
        if (stats.get(2) >= 2) {
            status += 2;
        }
        if (hasInteraction || stats.get(4) >= 4) {
            status += 4;
        }
        return status;
    }

    public static int isVillage(Set<PointOfInterest> pointOfInterests, ServerWorld world, BlockPos totemPos, boolean hasInteraction) {
        if (UtilLib.getStructureStartAt(world, totemPos, Structure.field_236381_q_) != StructureStart.field_214630_a) {
            return 7;
        }
        return TotemHelper.isVillage(TotemHelper.getVillageStats(pointOfInterests, (World)world), hasInteraction);
    }

    public static Map<Integer, Integer> getVillageStats(Set<PointOfInterest> pointOfInterests, final World world) {
        final Map poiTCounts = pointOfInterests.stream().map(PointOfInterest::func_218260_g).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        final AxisAlignedBB area = TotemHelper.getAABBAroundPOIs(pointOfInterests);
        return new HashMap<Integer, Integer>(){
            {
                this.put(1, poiTCounts.getOrDefault(PointOfInterestType.field_221069_q, 0L).intValue());
                this.put(2, (int)poiTCounts.entrySet().stream().filter(entry -> entry.getKey() != PointOfInterestType.field_221069_q).mapToLong(Map.Entry::getValue).sum());
                this.put(4, area == null ? 0 : world.func_217357_a(VillagerEntity.class, area).size());
            }
        };
    }

    @Nullable
    public static AxisAlignedBB getAABBAroundPOIs(@Nonnull Set<PointOfInterest> pois) {
        return pois.stream().map(poi -> new AxisAlignedBB(poi.func_218261_f()).func_186662_g(25.0)).reduce(AxisAlignedBB::func_111270_a).orElse(null);
    }

    public static void ringBell(World world, @Nonnull PlayerEntity player) {
        if (!world.field_72995_K) {
            Optional<TotemTileEntity> tile = TotemHelper.getTotemNearPos((ServerWorld)world, player.func_233580_cy_(), false);
            tile.ifPresent(s -> s.ringBell(player));
        }
    }
}

