/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DifficultyCalculator {
    @Nullable
    private static Difficulty calculateDifficulty(List<? extends PlayerEntity> playerList) {
        if (playerList == null || playerList.isEmpty()) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        int max = 0;
        int sum = 0;
        for (PlayerEntity playerEntity : playerList) {
            if (!playerEntity.func_70089_S()) continue;
            LazyOptional<FactionPlayerHandler> handler = FactionPlayerHandler.getOpt(playerEntity);
            int pLevel = handler.map(FactionPlayerHandler::getCurrentLevel).orElse(0);
            if (pLevel == 0) {
                min = 0;
                continue;
            }
            int level = (int)((float)pLevel / (float)handler.map(FactionPlayerHandler::getCurrentFaction).map(IPlayableFaction::getHighestReachableLevel).orElse(pLevel).intValue() * 100.0f);
            if (level < min) {
                min = level;
            }
            if (level > max) {
                max = level;
            }
            sum += max;
        }
        return new Difficulty(min, max, Math.round((float)sum / (float)playerList.size()));
    }

    public static Difficulty getWorldDifficulty(World w) {
        return DifficultyCalculator.calculateDifficulty(w.func_217369_A());
    }

    public static Difficulty getLocalDifficulty(World w, BlockPos center, int radius) {
        List list = w.func_217357_a(PlayerEntity.class, UtilLib.createBB(center, radius, true));
        return DifficultyCalculator.calculateDifficulty(list);
    }

    public static Difficulty getGlobalDifficulty() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            throw new IllegalStateException("You can only use this method on server side");
        }
        return DifficultyCalculator.calculateDifficulty(ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v());
    }

    @Nonnull
    public static Difficulty findDifficultyForPos(World world, BlockPos pos, int radius) {
        Difficulty d = DifficultyCalculator.getLocalDifficulty(world, pos, radius);
        if (d == null && (d = DifficultyCalculator.getWorldDifficulty(world)) == null && (d = DifficultyCalculator.getGlobalDifficulty()) == null) {
            d = new Difficulty(0, 0, 0);
        }
        return d;
    }
}

