/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import de.teamlapen.vampirism.items.StakeItem;
import de.teamlapen.vampirism.mixin.LivingEntityAccessor;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Helper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation EMPTY_ID = new ResourceLocation("null", "null");
    private static Method reflectionMethodExperiencePoints;

    public static boolean gettingSundamge(LivingEntity entity, IWorld world, @Nullable IProfiler profiler) {
        BlockPos pos;
        float angle;
        if (profiler != null) {
            profiler.func_76320_a("vampirism_checkSundamage");
        }
        if (entity instanceof PlayerEntity && entity.func_175149_v()) {
            return false;
        }
        RegistryKey<World> worldKey = Helper.getWorldKey(world);
        if (VampirismAPI.sundamageRegistry().getSundamageInDim(worldKey) && (!(world instanceof World) || !((World)world).func_72896_J()) && ((double)(angle = world.func_242415_f(1.0f)) > 0.78 || (double)angle < 0.24) && Helper.canBlockSeeSun(world, pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)MathHelper.func_76131_a((float)(entity.func_213302_cg() / 2.0f), (float)0.0f, (float)2.0f), entity.func_226281_cx_()))) {
            try {
                ResourceLocation biome = Helper.getBiomeId((IBiomeReader)world, pos);
                if (VampirismAPI.sundamageRegistry().getSundamageInBiome(biome) && world instanceof World && !VampirismWorld.getOpt((World)world).map(vw -> vw.isInsideArtificialVampireFogArea(new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_()))).orElse(false).booleanValue()) {
                    if (profiler != null) {
                        profiler.func_76319_b();
                    }
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (profiler != null) {
            profiler.func_76319_b();
        }
        return false;
    }

    public static boolean canBlockSeeSun(IWorld world, BlockPos pos) {
        if (pos.func_177956_o() >= world.func_181545_F()) {
            return world.func_226660_f_(pos);
        }
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), world.func_181545_F(), pos.func_177952_p());
        if (!world.func_226660_f_(blockpos)) {
            return false;
        }
        int liquidBlocks = 0;
        blockpos = blockpos.func_177977_b();
        while (blockpos.func_177956_o() > pos.func_177956_o()) {
            BlockState state = world.func_180495_p(blockpos);
            if (state.func_185904_a().func_76224_d()) {
                if (++liquidBlocks >= (Integer)VampirismConfig.BALANCE.vpSundamageWaterblocks.get()) {
                    return false;
                }
            } else {
                if (state.func_200132_m() && (state.func_224755_d((IBlockReader)world, pos, Direction.DOWN) || state.func_224755_d((IBlockReader)world, pos, Direction.UP))) {
                    return false;
                }
                if (state.func_200016_a((IBlockReader)world, blockpos) > 0) {
                    return false;
                }
            }
            blockpos = blockpos.func_177977_b();
        }
        return true;
    }

    @Deprecated
    @Nonnull
    public static EnumStrength getGarlicStrength(Entity e, RegistryKey<World> world) {
        return Helper.getGarlicStrengthAt(world, e.func_233580_cy_());
    }

    @Deprecated
    @Nonnull
    public static EnumStrength getGarlicStrengthAt(RegistryKey<World> world, BlockPos pos) {
        return VampirismAPI.getGarlicChunkHandler(world).getStrengthAtChunk(new ChunkPos(pos));
    }

    @Nonnull
    public static EnumStrength getGarlicStrength(Entity e, IWorld world) {
        return Helper.getGarlicStrengthAt(world, e.func_233580_cy_());
    }

    @Nonnull
    public static EnumStrength getGarlicStrengthAt(IWorld world, BlockPos pos) {
        return world instanceof World ? VampirismAPI.getVampirismWorld((World)world).map(vw -> vw.getStrengthAtChunk(new ChunkPos(pos))).orElse(EnumStrength.NONE) : EnumStrength.NONE;
    }

    @Nonnull
    public static RegistryKey<World> getWorldKey(IWorld world) {
        return world instanceof World ? ((World)world).func_234923_W_() : (world instanceof IServerWorld ? ((IServerWorld)world).func_201672_e().func_234923_W_() : World.field_234918_g_);
    }

    public static boolean canBecomeVampire(PlayerEntity player) {
        return FactionPlayerHandler.getOpt(player).map(v -> v.canJoin(VReference.VAMPIRE_FACTION)).orElse(false);
    }

    public static boolean canTurnPlayer(IVampire biter, @Nullable PlayerEntity target) {
        if (target != null && (target.func_184812_l_() || target.func_175149_v())) {
            return false;
        }
        if (biter instanceof IVampirePlayer) {
            if (!((Boolean)VampirismConfig.SERVER.playerCanTurnPlayer.get()).booleanValue()) {
                return false;
            }
            return PermissionAPI.hasPermission((PlayerEntity)((IVampirePlayer)biter).getRepresentingPlayer(), (String)"vampirism.infect.player");
        }
        return (Boolean)VampirismConfig.SERVER.disableMobBiteInfection.get() == false;
    }

    public static boolean isVampire(Entity entity) {
        return VReference.VAMPIRE_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isHunter(Entity entity) {
        return VReference.HUNTER_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isHunter(PlayerEntity entity) {
        return VReference.HUNTER_FACTION.equals(VampirismPlayerAttributes.get((PlayerEntity)entity).faction);
    }

    public static boolean isVampire(PlayerEntity entity) {
        return VReference.VAMPIRE_FACTION.equals(VampirismPlayerAttributes.get((PlayerEntity)entity).faction);
    }

    public static boolean areSkillsEnabled(ISkillHandler skillHandler, ISkill ... skills) {
        if (skills == null) {
            return true;
        }
        for (ISkill skill : skills) {
            if (skillHandler.isSkillEnabled(skill)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEntityInVampireBiome(Entity e) {
        if (e == null) {
            return false;
        }
        World w = e.func_130014_f_();
        Biome b = w.func_226691_t_(e.func_233580_cy_());
        ResourceLocation biomeId = Helper.getBiomeId((IBiomeReader)w, b);
        Objects.requireNonNull(biomeId, "Cannot determine id of local biome");
        return ((Biome)ModBiomes.VAMPIRE_FOREST.get()).getRegistryName().equals((Object)biomeId) || ((Biome)ModBiomes.VAMPIRE_FOREST_HILLS.get()).getRegistryName().equals((Object)biomeId);
    }

    public static boolean isPosInVampireBiome(BlockPos pos, IWorldReader level) {
        Biome biome = level.func_226691_t_(pos);
        return ((Biome)ModBiomes.VAMPIRE_FOREST.get()).equals(biome) || ((Biome)ModBiomes.VAMPIRE_FOREST_HILLS.get()).equals(biome);
    }

    public static boolean isEntityInArtificalVampireFogArea(Entity e) {
        if (e == null) {
            return false;
        }
        World w = e.func_130014_f_();
        return VampirismWorld.getOpt(w).map(vh -> vh.isInsideArtificialVampireFogArea(e.func_233580_cy_())).orElse(false);
    }

    public static ResourceLocation getBiomeId(Entity e) {
        return Helper.getBiomeId((IBiomeReader)e.func_130014_f_(), e.func_233580_cy_());
    }

    public static ResourceLocation getBiomeId(IBiomeReader world, BlockPos pos) {
        return Helper.getBiomeId(world, world.func_226691_t_(pos));
    }

    public static ResourceLocation getBiomeId(IBiomeReader world, Biome biome) {
        return world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
    }

    public static boolean canUseFactionItem(ItemStack stack, IFactionLevelItem item, IFactionPlayerHandler playerHandler) {
        IPlayableFaction usingFaction = item.getUsingFaction(stack);
        ISkill requiredSkill = item.getRequiredSkill(stack);
        int reqLevel = item.getMinLevel(stack);
        if (usingFaction != null && !playerHandler.isInFaction(usingFaction)) {
            return false;
        }
        if (playerHandler.getCurrentLevel() < reqLevel) {
            return false;
        }
        if (requiredSkill == null) {
            return true;
        }
        return playerHandler.getCurrentFactionPlayer().map(ISkillPlayer::getSkillHandler).map(s -> s.isSkillEnabled(requiredSkill)).orElse(false);
    }

    public static int getExperiencePoints(LivingEntity entity, PlayerEntity player) {
        return ((LivingEntityAccessor)entity).invokeGetExperiencePoints_vampirism(player);
    }

    public static boolean attemptToGuessGenderSafe(PlayerEntity p) {
        Map textureMap;
        if (p instanceof ServerPlayerEntity && (textureMap = ((ServerPlayerEntity)p).field_71133_b.func_147130_as().getTextures(p.func_146103_bH(), false)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture skinTexture = (MinecraftProfileTexture)textureMap.get(MinecraftProfileTexture.Type.SKIN);
            return "slim".equals(skinTexture.getMetadata("model"));
        }
        return false;
    }

    public static <T extends Entity> Optional<T> createEntity(@Nonnull EntityType<T> type, @Nonnull World world) {
        Entity e = type.func_200721_a(world);
        if (e == null) {
            LOGGER.warn("Failed to create entity of type {}", (Object)type.getRegistryName());
            return Optional.empty();
        }
        return Optional.of(e);
    }

    @Nonnull
    public static ResourceLocation getIDSafe(ForgeRegistryEntry<?> registryObject) {
        ResourceLocation id = registryObject.getRegistryName();
        if (id == null) {
            LOGGER.warn("RegistryName not set for {}", registryObject);
            return EMPTY_ID;
        }
        return id;
    }

    public static ListNBT newDoubleNBTList(double ... numbers) {
        ListNBT listnbt = new ListNBT();
        for (double d0 : numbers) {
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)d0));
        }
        return listnbt;
    }

    public static boolean canKillVampires(DamageSource source) {
        if (!source.func_76357_e() && ((List)VampirismConfig.BALANCE.vpImmortalFromDamageSources.get()).contains(source.func_76355_l())) {
            if (source.func_76364_f() instanceof LivingEntity) {
                return source.func_76364_f() instanceof IHunterMob || ((LivingEntity)source.func_76364_f()).func_184614_ca().func_77973_b() instanceof StakeItem;
            }
            if (source.func_76364_f() instanceof CrossbowArrowEntity) {
                return ((CrossbowArrowEntity)source.func_76364_f()).getArrowType() == CrossbowArrowItem.EnumArrowType.VAMPIRE_KILLER;
            }
            return false;
        }
        return true;
    }

    public static boolean isDBNODisabledForCompat(Entity t) {
        if (!t.field_70170_p.func_201670_d() && ModList.get().isLoaded("playerrevive") && t.func_184102_h() != null && t.func_184102_h().func_71344_c()) {
            LOGGER.warn("Disabled DBNO due to soft-lock bug together with PlayerRevive. Uninstall PlayerRevive if you want to use DBNO");
            return true;
        }
        return false;
    }
}

