/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerSkinHelper {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 5, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());

    public static void updateGameProfileAsync(GameProfile input, Consumer<GameProfile> callback) {
        if (input != null) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                callback.accept(input);
            } else if (SkullTileEntity.field_184298_j != null && SkullTileEntity.field_184299_k != null) {
                THREAD_POOL.submit(() -> {
                    GameProfile gameprofile;
                    GameProfile gameProfile = gameprofile = input.getId() == null ? SkullTileEntity.field_184298_j.func_152655_a(input.getName()) : SkullTileEntity.field_184298_j.func_152652_a(input.getId());
                    if (gameprofile == null) {
                        gameprofile = input;
                    } else {
                        Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
                        if (property == null) {
                            gameprofile = SkullTileEntity.field_184299_k.fillProfileProperties(gameprofile, true);
                        }
                    }
                    callback.accept(gameprofile);
                });
            } else {
                callback.accept(input);
            }
        } else {
            callback.accept(input);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void obtainPlayerSkinPropertiesAsync(GameProfile input, Consumer<Pair<ResourceLocation, Boolean>> callback) {
        PlayerSkinHelper.updateGameProfileAsync(input, p -> {
            boolean alex;
            ResourceLocation loc;
            Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(p);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                MinecraftProfileTexture t = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                loc = Minecraft.func_71410_x().func_152342_ad().func_152792_a(t, MinecraftProfileTexture.Type.SKIN);
                alex = "slim".equals(t.getMetadata("model"));
            } else {
                loc = DefaultPlayerSkin.func_177334_a((UUID)p.getId());
                alex = "slim".equals(DefaultPlayerSkin.func_177332_b((UUID)p.getId()));
            }
            callback.accept(Pair.of((Object)loc, (Object)alex));
        });
    }
}

