/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.world.IWorldGenManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

@MethodsReturnNonnullByDefault
public class WorldGenManager
implements IWorldGenManager {
    @Nonnull
    private final Map<ResourceLocation, Set<ResourceLocation>> ignoreStructureBiome = Maps.newHashMap();
    @Nonnull
    private final Map<ResourceLocation, Set<Biome.Category>> ignoreStructureBiomeCategory = Maps.newHashMap();

    @Override
    public boolean canStructureBeGeneratedInBiome(ResourceLocation featureRegistryName, ResourceLocation biomeRegistryKey, Biome.Category biomeCategory) {
        if (this.ignoreStructureBiome.containsKey(featureRegistryName) && this.ignoreStructureBiome.get(featureRegistryName).contains(biomeRegistryKey)) {
            return false;
        }
        if (this.ignoreStructureBiomeCategory.containsKey(featureRegistryName)) {
            Set<Biome.Category> categories = this.ignoreStructureBiomeCategory.get(featureRegistryName);
            return !categories.contains(biomeCategory);
        }
        return true;
    }

    @Override
    public Set<Biome.Category> getIgnoredBiomeCategories(ResourceLocation structure) {
        if (!this.ignoreStructureBiomeCategory.containsKey(structure)) {
            return Sets.newHashSet();
        }
        return ImmutableSet.copyOf((Collection)this.ignoreStructureBiomeCategory.get(structure));
    }

    @Override
    public Set<ResourceLocation> getIgnoredBiomes(ResourceLocation structure) {
        if (!this.ignoreStructureBiome.containsKey(structure)) {
            return Sets.newHashSet();
        }
        return ImmutableSet.copyOf((Collection)this.ignoreStructureBiome.get(structure));
    }

    @Override
    public void removeStructureFromBiomeCategories(ResourceLocation structure, List<Biome.Category> categories) {
        this.ignoreStructureBiomeCategory.computeIfAbsent(structure, name -> Sets.newHashSet()).addAll(categories);
    }

    @Override
    public void removeStructureFromBiomes(ResourceLocation structure, List<ResourceLocation> biomes) {
        this.ignoreStructureBiome.computeIfAbsent(structure, name -> Sets.newHashSet()).addAll(biomes);
    }
}

