/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.biome;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.blocks.CastleBricksBlock;
import de.teamlapen.vampirism.blocks.CursedEarthBlock;
import de.teamlapen.vampirism.blocks.DarkSpruceLeavesBlock;
import de.teamlapen.vampirism.blocks.VampirismFlowerBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.mixin.FlatGenerationSettingsAccessor;
import de.teamlapen.vampirism.world.gen.features.VampireDungeonFeature;
import de.teamlapen.vampirism.world.gen.features.VampirismLakeFeature;
import de.teamlapen.vampirism.world.gen.treedecorator.TrunkCursedVineTreeDecorator;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.ThreeLayerFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.SpruceFoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;

public class VampirismBiomeFeatures {
    public static BlockClusterFeatureConfig BUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.CURSED_ROOTS.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(7).func_227322_d_();
    public static BlockClusterFeatureConfig DEFAULT_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_150349_c.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(16).func_227322_d_();
    public static BlockClusterFeatureConfig VAMPIRE_FLOWER = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((VampirismFlowerBlock)ModBlocks.VAMPIRE_ORCHID.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(6).func_227322_d_();
    public static ConfiguredFeature<?, ?> patch_bush;
    public static ConfiguredFeature<?, ?> patch_grass_forest;
    public static ConfiguredFeature<?, ?> ore_cursed_earth;
    public static ConfiguredFeature<?, ?> ore_dark_stone;
    public static ConfiguredFeature<?, ?> vampire_flower;
    public static ConfiguredFeature<?, ?> mod_water_lake;
    public static ConfiguredFeature<?, ?> vampire_dungeon;
    public static StructureFeature<?, ?> hunter_camp;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> dark_spruce_tree;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> cursed_spruce_tree;
    public static ConfiguredFeature<?, ?> vampire_trees;
    public static ConfiguredFeature<?, ?> dark_stone;

    public static void registerBiomeFeatures() {
        patch_bush = VampirismBiomeFeatures.registerFeature("patch_bush", Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BUSH_CONFIG).func_227228_a_(Features.Placements.field_244002_m));
        patch_grass_forest = VampirismBiomeFeatures.registerFeature("patch_grass_forest", (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DEFAULT_GRASS_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2));
        ore_cursed_earth = VampirismBiomeFeatures.registerFeature("ore_cursed_earth", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).func_176223_P(), 33)).func_242733_d(256)).func_242728_a()).func_242731_b(10));
        ore_dark_stone = VampirismBiomeFeatures.registerFeature("ore_dark_stone", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((CastleBricksBlock)ModBlocks.CASTLE_BLOCK_DARK_STONE.get()).func_176223_P(), 33)).func_242733_d(80)).func_242728_a()).func_242731_b(10));
        vampire_flower = VampirismBiomeFeatures.registerFeature("vampire_flower", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)VAMPIRE_FLOWER).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5));
        mod_water_lake = VampirismBiomeFeatures.registerFeature("mod_water_lake", ((VampirismLakeFeature)ModFeatures.MOD_LAKE.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150355_j.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
        vampire_dungeon = VampirismBiomeFeatures.registerFeature("vampire_dungeon", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((VampireDungeonFeature)ModFeatures.VAMPIRE_DUNGEON.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(256)).func_242728_a()).func_242731_b(2));
        hunter_camp = VampirismBiomeFeatures.registerStructure("hunter_camp", ((Structure)ModFeatures.HUNTER_CAMP.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        dark_spruce_tree = VampirismBiomeFeatures.registerFeature("dark_spruce_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)ModBlocks.DARK_SPRUCE_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((DarkSpruceLeavesBlock)ModBlocks.DARK_SPRUCE_LEAVES.get()).func_176223_P()), (FoliagePlacer)new SpruceFoliagePlacer(FeatureSpread.func_242253_a((int)2, (int)1), FeatureSpread.func_242253_a((int)0, (int)2), FeatureSpread.func_242253_a((int)3, (int)7)), (AbstractTrunkPlacer)new StraightTrunkPlacer(11, 2, 2), (AbstractFeatureSizeType)new ThreeLayerFeature(5, 8, 0, 3, 3, OptionalInt.of(5))).func_225568_b_()));
        cursed_spruce_tree = VampirismBiomeFeatures.registerFeature("cursed_spruce_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)ModBlocks.CURSED_SPRUCE_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((DarkSpruceLeavesBlock)ModBlocks.DARK_SPRUCE_LEAVES.get()).func_176223_P()), (FoliagePlacer)new SpruceFoliagePlacer(FeatureSpread.func_242253_a((int)2, (int)1), FeatureSpread.func_242253_a((int)0, (int)2), FeatureSpread.func_242253_a((int)3, (int)7)), (AbstractTrunkPlacer)new StraightTrunkPlacer(11, 2, 2), (AbstractFeatureSizeType)new ThreeLayerFeature(5, 8, 0, 3, 3, OptionalInt.of(5))).func_236703_a_((List)ImmutableList.of((Object)((Object)TrunkCursedVineTreeDecorator.INSTANCE))).func_225568_b_()));
        vampire_trees = VampirismBiomeFeatures.registerFeature("vampire_trees", Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)cursed_spruce_tree.func_227227_a_(0.3f)), dark_spruce_tree)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        dark_stone = VampirismBiomeFeatures.registerFeature("dark_stone", Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(((CastleBricksBlock)ModBlocks.CASTLE_BLOCK_DARK_STONE.get()).func_176223_P(), FeatureSpread.func_242253_a((int)2, (int)4), 2, (List)ImmutableList.of((Object)Blocks.field_150348_b.func_176223_P()))).func_227228_a_(Features.Placements.field_244003_n));
    }

    private static <T extends IFeatureConfig> ConfiguredFeature<T, ?> registerFeature(String name, ConfiguredFeature<T, ?> feature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("vampirism", name), feature);
    }

    private static <T extends IFeatureConfig> StructureFeature<T, ?> registerStructure(String name, StructureFeature<T, ?> structure) {
        return (StructureFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("vampirism", name), structure);
    }

    public static void init() {
        if (((Boolean)VampirismConfig.COMMON.enforceTentGeneration.get()).booleanValue()) {
            FlatGenerationSettingsAccessor.getStructures_vampirism().put((Structure<?>)ModFeatures.HUNTER_CAMP.get(), hunter_camp);
        }
    }

    public static void addVampireFlower(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, vampire_flower);
    }

    public static void addWaterSprings(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243833_af);
    }

    public static void addModdedWaterLake(BiomeGenerationSettings.Builder builder) {
        builder.func_242510_a(GenerationStage.Decoration.LAKES.ordinal(), () -> mod_water_lake);
    }

    public static void addVampireTrees(BiomeGenerationSettings.Builder builder) {
        builder.func_242510_a(GenerationStage.Decoration.VEGETAL_DECORATION.ordinal(), () -> vampire_trees);
    }

    public static void addDarkStoneSoftDisk(BiomeGenerationSettings.Builder builder) {
        builder.func_242510_a(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal(), () -> dark_stone);
    }

    public static void addBushPatch(BiomeGenerationSettings.Builder builder) {
        builder.func_242510_a(GenerationStage.Decoration.VEGETAL_DECORATION.ordinal(), () -> patch_bush);
        builder.func_242510_a(GenerationStage.Decoration.VEGETAL_DECORATION.ordinal(), () -> patch_grass_forest);
    }

    public static void addUndergroundVariety(BiomeGenerationSettings.Builder builder) {
        builder.func_242510_a(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal(), () -> Features.field_243893_bm);
        builder.func_242510_a(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal(), () -> ore_cursed_earth);
        builder.func_242510_a(GenerationStage.Decoration.UNDERGROUND_ORES.ordinal(), () -> ore_dark_stone);
    }
}

