/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.util.MixinHooks;
import de.teamlapen.vampirism.world.gen.util.BiomeTopBlockProcessor;
import de.teamlapen.vampirism.world.gen.util.RandomBlockState;
import de.teamlapen.vampirism.world.gen.util.RandomStructureProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;

public class VampirismWorldGen {
    public static boolean debug = false;

    public static void createJigsawPool() {
        VampirismWorldGen.setupSingleJigsawPieceGeneration();
        JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(new ResourceLocation("vampirism", "village/entities/hunter_trainer"), new ResourceLocation("empty"), (List)Lists.newArrayList((Object[])new Pair[]{Pair.of(VampirismWorldGen.singleJigsawPieceFunction("village/entities/hunter_trainer"), (Object)1)}), JigsawPattern.PlacementBehaviour.RIGID));
    }

    public static void addVillageStructures(DynamicRegistries dynamicRegistries) {
        VampirismWorldGen.addHunterTrainerHouse(dynamicRegistries, VampirismWorldGen.getDefaultPools());
        VampirismWorldGen.addTotem(dynamicRegistries, VampirismWorldGen.getDefaultPools());
        VampirismWorldGen.replaceTemples(dynamicRegistries, VampirismWorldGen.getTempleReplacements());
    }

    private static Map<ResourceLocation, BiomeType> getDefaultPools() {
        return Collections.unmodifiableMap(new HashMap<ResourceLocation, BiomeType>(){
            {
                this.put(new ResourceLocation("village/plains/houses"), BiomeType.PLAINS);
                this.put(new ResourceLocation("village/desert/houses"), BiomeType.DESERT);
                this.put(new ResourceLocation("village/savanna/houses"), BiomeType.SAVANNA);
                this.put(new ResourceLocation("village/taiga/houses"), BiomeType.TAIGA);
                this.put(new ResourceLocation("village/snowy/houses"), BiomeType.SNOWY);
                this.put(new ResourceLocation("repurposed_structures", "village/badlands/houses"), BiomeType.BADLANDS);
                this.put(new ResourceLocation("repurposed_structures", "village/birch/houses"), BiomeType.BIRCH);
                this.put(new ResourceLocation("repurposed_structures", "village/dark_forest/houses"), BiomeType.DARK_FOREST);
                this.put(new ResourceLocation("repurposed_structures", "village/jungle/houses"), BiomeType.JUNGLE);
                this.put(new ResourceLocation("repurposed_structures", "village/mountains/houses"), BiomeType.MOUNTAINS);
                this.put(new ResourceLocation("repurposed_structures", "village/giant_taiga/houses"), BiomeType.GIANT_TAIGA);
                this.put(new ResourceLocation("repurposed_structures", "village/oak/houses"), BiomeType.OAK);
                this.put(new ResourceLocation("repurposed_structures", "village/swamp/houses"), BiomeType.SWAMP);
                this.put(new ResourceLocation("repurposed_structures", "village/crimson/houses"), BiomeType.CRIMSON);
                this.put(new ResourceLocation("repurposed_structures", "village/warped/houses"), BiomeType.WARPED);
            }
        });
    }

    private static Map<ResourceLocation, Map<String, JigsawPiece>> getTempleReplacements() {
        return new HashMap<ResourceLocation, Map<String, JigsawPiece>>(){
            {
                this.put(new ResourceLocation("village/plains/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)VampirismWorldGen.singleJigsawPiece("village/plains/houses/plains_temple_3", ProcessorLists.field_244107_g), (Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)VampirismWorldGen.singleJigsawPiece("village/plains/houses/plains_temple_4", ProcessorLists.field_244107_g)));
                this.put(new ResourceLocation("village/desert/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)VampirismWorldGen.singleJigsawPiece("village/desert/houses/desert_temple_1"), (Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)VampirismWorldGen.singleJigsawPiece("village/desert/houses/desert_temple_2")));
                this.put(new ResourceLocation("village/savanna/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)VampirismWorldGen.singleJigsawPiece("village/savanna/houses/savanna_temple_1"), (Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)VampirismWorldGen.singleJigsawPiece("village/savanna/houses/savanna_temple_2")));
                this.put(new ResourceLocation("village/taiga/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/taiga/houses/taiga_temple_1"), (Object)VampirismWorldGen.singleJigsawPiece("village/taiga/houses/taiga_temple_1", ProcessorLists.field_244107_g)));
                this.put(new ResourceLocation("village/snowy/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)VampirismWorldGen.singleJigsawPiece("village/snowy/houses/snowy_temple_1")));
                this.put(new ResourceLocation("village/plains/zombie/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)VampirismWorldGen.singleJigsawPiece("village/plains/houses/plains_temple_3", ProcessorLists.field_244102_b), (Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)VampirismWorldGen.singleJigsawPiece("village/plains/houses/plains_temple_4", ProcessorLists.field_244102_b)));
                this.put(new ResourceLocation("village/desert/zombie/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)VampirismWorldGen.singleJigsawPiece("village/desert/houses/desert_temple_1", ProcessorLists.field_244106_f), (Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)VampirismWorldGen.singleJigsawPiece("village/desert/houses/desert_temple_2", ProcessorLists.field_244106_f)));
                this.put(new ResourceLocation("village/savanna/zombie/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)VampirismWorldGen.singleJigsawPiece("village/savanna/houses/savanna_temple_1", ProcessorLists.field_244103_c), (Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)VampirismWorldGen.singleJigsawPiece("village/savanna/houses/savanna_temple_2", ProcessorLists.field_244103_c)));
                this.put(new ResourceLocation("village/taiga/zombie/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/taiga/zombie/houses/taiga_temple_1"), (Object)VampirismWorldGen.singleJigsawPiece("village/taiga/houses/taiga_temple_1", ProcessorLists.field_244105_e)));
                this.put(new ResourceLocation("village/snowy/zombie/houses"), ImmutableMap.of((Object)VampirismWorldGen.singleLegacyJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)VampirismWorldGen.singleJigsawPiece("village/snowy/houses/snowy_temple_1", ProcessorLists.field_244104_d)));
            }
        };
    }

    private static void replaceTemples(DynamicRegistries dynamicRegistries, Map<ResourceLocation, Map<String, JigsawPiece>> patternReplacements) {
        if (!((Boolean)VampirismConfig.COMMON.villageReplaceTemples.get()).booleanValue()) {
            return;
        }
        dynamicRegistries.func_230521_a_(Registry.field_243555_ax).ifPresent(jigsawRegistry -> patternReplacements.forEach((pool, replacements) -> jigsawRegistry.func_241873_b(pool).ifPresent(pattern -> replacements.forEach((original, modified) -> {
            ArrayList oldPieces = new ArrayList();
            pattern.field_214953_e.removeIf(piece -> {
                if (piece.toString().equals(original)) {
                    oldPieces.add(piece);
                    return true;
                }
                return false;
            });
            int i = 0;
            while ((double)i < (double)oldPieces.size() * 0.6) {
                pattern.field_214953_e.add(modified);
                pattern.field_214953_e.add(oldPieces.get(i));
                ++i;
            }
            ArrayList weightedElementList = new ArrayList(pattern.field_214952_d);
            Optional<Pair> originalPiece = weightedElementList.stream().filter(entry -> ((JigsawPiece)entry.getFirst()).toString().equals(original)).findAny();
            originalPiece.ifPresent(originalEntry -> {
                weightedElementList.remove(originalPiece.get());
                weightedElementList.add(new Pair(originalEntry.getFirst(), (Object)((int)((double)((Integer)originalEntry.getSecond()).intValue() * 0.6))));
                weightedElementList.add(new Pair(modified, (Object)((int)((double)((Integer)originalEntry.getSecond()).intValue() * 0.6))));
            });
            pattern.field_214952_d = weightedElementList;
        }))));
    }

    private static void addHunterTrainerHouse(DynamicRegistries reg, Map<ResourceLocation, BiomeType> pools) {
        reg.func_230521_a_(Registry.field_243555_ax).ifPresent(patternRegistry -> pools.forEach((pool, type) -> patternRegistry.func_241873_b(pool).ifPresent(pattern -> {
            SingleJigsawPiece piece = VampirismWorldGen.singleJigsawPiece("village/" + type.path + "/houses/hunter_trainer", new StructureProcessorList(Collections.emptyList()));
            for (int i = 0; i < (Integer)VampirismConfig.COMMON.villageHunterTrainerWeight.get(); ++i) {
                pattern.field_214953_e.add(piece);
            }
            ArrayList<Pair> weightedElementList = new ArrayList<Pair>(pattern.field_214952_d);
            weightedElementList.add(new Pair((Object)piece, VampirismConfig.COMMON.villageHunterTrainerWeight.get()));
            pattern.field_214952_d = weightedElementList;
        })));
    }

    private static void addTotem(DynamicRegistries reg, Map<ResourceLocation, BiomeType> pools) {
        RandomStructureProcessor factionProcessor = new RandomStructureProcessor((List<RandomBlockState>)ImmutableList.of((Object)((Object)new RandomBlockState((RuleTest)new RandomBlockMatchRuleTest((Block)ModBlocks.TOTEM_TOP.get(), ((Double)VampirismConfig.COMMON.villageTotemFactionChance.get()).floatValue()), (RuleTest)AlwaysTrueRuleTest.field_215190_a, ((TotemTopBlock)ModBlocks.TOTEM_TOP.get()).func_176223_P(), TotemTopBlock.getBlocks().stream().filter(totem -> totem != ModBlocks.TOTEM_TOP.get() && !totem.isCrafted()).map(Block::func_176223_P).collect(Collectors.toList())))));
        BiomeTopBlockProcessor biomeTopBlockProcessor = new BiomeTopBlockProcessor(Blocks.field_150346_d.func_176223_P());
        SingleJigsawPiece totem2 = VampirismWorldGen.singleJigsawPiece("village/totem", new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{factionProcessor, biomeTopBlockProcessor})));
        reg.func_230521_a_(Registry.field_243555_ax).ifPresent(arg_0 -> VampirismWorldGen.lambda$addTotem$13(pools, (JigsawPiece)totem2, arg_0));
    }

    private static void setupSingleJigsawPieceGeneration() {
        ArrayList list = Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation("vampirism", "village/totem")});
        list.addAll(Arrays.stream(BiomeType.values()).map(type -> new ResourceLocation("vampirism", "village/" + type.path + "/houses/hunter_trainer")).collect(Collectors.toList()));
        MixinHooks.addSingleInstanceStructure(list);
    }

    private static SingleJigsawPiece singleJigsawPiece(@Nonnull String path) {
        return VampirismWorldGen.singleJigsawPiece(path, new StructureProcessorList(Collections.emptyList()));
    }

    private static SingleJigsawPiece singleJigsawPiece(@Nonnull String path, @Nonnull StructureProcessorList processors) {
        return (SingleJigsawPiece)SingleJigsawPiece.func_242861_b((String)("vampirism:" + path), (StructureProcessorList)processors).apply(JigsawPattern.PlacementBehaviour.RIGID);
    }

    private static Function<JigsawPattern.PlacementBehaviour, SingleJigsawPiece> singleJigsawPieceFunction(@Nonnull String path) {
        return VampirismWorldGen.singleJigsawPieceFunction(path, new StructureProcessorList(Collections.emptyList()));
    }

    private static Function<JigsawPattern.PlacementBehaviour, SingleJigsawPiece> singleJigsawPieceFunction(@Nonnull String path, @Nonnull StructureProcessorList processors) {
        return SingleJigsawPiece.func_242861_b((String)("vampirism:" + path), (StructureProcessorList)processors);
    }

    private static String singleJigsawString(String resourceLocation) {
        return "Single[Left[" + resourceLocation + "]]";
    }

    private static String singleLegacyJigsawString(String resourceLocation) {
        return "LegacySingle[Left[" + resourceLocation + "]]";
    }

    private static /* synthetic */ void lambda$addTotem$13(Map pools, JigsawPiece totem, MutableRegistry patternRegistry) {
        pools.forEach((pool, type) -> patternRegistry.func_241873_b(pool).ifPresent(pattern -> {
            for (int i = 0; i < (Integer)VampirismConfig.COMMON.villageTotemWeight.get(); ++i) {
                pattern.field_214953_e.add(totem);
            }
            ArrayList<Pair> weightedElementList = new ArrayList<Pair>(pattern.field_214952_d);
            weightedElementList.add(new Pair((Object)totem, VampirismConfig.COMMON.villageTotemWeight.get()));
            pattern.field_214952_d = weightedElementList;
        }));
    }

    private static enum BiomeType {
        PLAINS("plains"),
        TAIGA("taiga"),
        DESERT("desert"),
        SNOWY("snowy"),
        SAVANNA("savanna"),
        BADLANDS("badlands"),
        BIRCH("birch"),
        DARK_FOREST("dark_forest"),
        CRIMSON("crimson"),
        GIANT_TAIGA("giant_taiga"),
        JUNGLE("jungle"),
        MOUNTAINS("mountains"),
        OAK("oak"),
        SWAMP("swamp"),
        WARPED("warped");

        public final String path;

        private BiomeType(String path) {
            this.path = path;
        }
    }
}

