/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structures.huntercamp;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.blocks.FirePlaceBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.blocks.TentMainBlock;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.tileentity.TentTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
public abstract class HunterCampPieces
extends StructurePiece {
    protected final int x;
    protected final int z;
    protected final Block baseBlock;
    protected int y;

    public static void init(int chunkX, int chunkZ, Biome biomeIn, Random rand, List<StructurePiece> componentsIn) {
        Fireplace hunterCamp = new Fireplace(rand, chunkX * 16 + rand.nextInt(16), 63, chunkZ * 16 + rand.nextInt(16), biomeIn.func_242440_e().func_242502_e().func_204108_a().func_177230_c());
        componentsIn.add(hunterCamp);
        hunterCamp.func_74861_a(hunterCamp, componentsIn, rand);
    }

    public HunterCampPieces(IStructurePieceType structurePieceType, int part, int x, int y, int z, Block baseBlock) {
        super(structurePieceType, part);
        this.baseBlock = baseBlock;
        this.x = x;
        this.y = y;
        this.z = z;
        this.setBoundingBox();
    }

    public HunterCampPieces(IStructurePieceType structurePieceType, CompoundNBT nbt) {
        super(structurePieceType, nbt);
        this.baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("baseBlock")));
        this.x = nbt.func_74762_e("x");
        this.y = nbt.func_74762_e("y");
        this.z = nbt.func_74762_e("z");
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos, BlockPos blockPos) {
        this.y = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.x, this.z);
        this.setBoundingBox();
        return this.testPreconditions(worldIn, structureManager, chunkPos);
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("x", this.x);
        tagCompound.func_74768_a("y", this.y);
        tagCompound.func_74768_a("z", this.z);
        tagCompound.func_74778_a("baseBlock", this.baseBlock.getRegistryName().toString());
    }

    protected void setBoundingBox() {
        this.field_74887_e = new MutableBoundingBox(this.x - 1, this.y, this.z - 1, this.x + 1, this.y + 2, this.z + 1);
    }

    protected boolean testPreconditions(ISeedReader worldIn, StructureManager manager, ChunkPos chunkPos) {
        if (!((Boolean)VampirismConfig.COMMON.enableHunterTentGeneration.get()).booleanValue()) {
            return false;
        }
        for (StructureStart value : worldIn.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b).func_201609_c().values()) {
            if (value == StructureStart.field_214630_a || value.func_214627_k() == ModFeatures.HUNTER_CAMP.get()) continue;
            return false;
        }
        return this.y >= 63 && !worldIn.func_180495_p(new BlockPos(this.x, this.y - 1, this.z)).func_185904_a().func_76224_d() && !manager.func_235010_a_(new BlockPos(this.x, this.y, this.z), false, Structure.field_236381_q_).func_75069_d();
    }

    public static class SpecialBlock
    extends HunterCampPieces {
        private final Direction direction;
        private final boolean advanced;

        public SpecialBlock(int x, int y, int z, Direction direction, Block baseBlocks, boolean advanced) {
            super(ModFeatures.hunter_camp_special, 2, x, y, z, baseBlocks);
            this.func_186164_a(direction);
            this.direction = direction;
            this.advanced = advanced;
        }

        public SpecialBlock(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModFeatures.hunter_camp_special, compoundNBT);
            this.direction = Direction.func_176731_b((int)compoundNBT.func_74762_e("dir"));
            this.advanced = compoundNBT.func_74767_n("advanced");
        }

        @Override
        public boolean func_230383_a_(ISeedReader worldIn, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos, BlockPos blockPos) {
            if (!super.func_230383_a_(worldIn, structureManager, chunkGenerator, random, structureBoundingBoxIn, chunkPos, blockPos)) {
                return false;
            }
            if (this.advanced) {
                if (!worldIn.func_180495_p(new BlockPos(this.x + 1, worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.x + 1, this.z) - 1, this.z)).func_185904_a().func_76222_j()) {
                    this.func_175811_a(worldIn, ((WeaponTableBlock)ModBlocks.WEAPON_TABLE.get()).func_176223_P(), 2, worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.x + 1, this.z) - this.y, 1, structureBoundingBoxIn);
                }
                if (!worldIn.func_180495_p(new BlockPos(this.x - 1, worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.x - 1, this.z) - 1, this.z)).func_185904_a().func_76222_j()) {
                    this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 0, worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.x - 1, this.z) - this.y, 1, structureBoundingBoxIn);
                }
            } else {
                this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 1, 0, 1, structureBoundingBoxIn);
            }
            return true;
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("dir", this.direction.func_176736_b());
            tagCompound.func_74757_a("advanced", this.advanced);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean testPreconditions(ISeedReader worldIn, StructureManager manager, ChunkPos chunkPos) {
            if (!super.testPreconditions(worldIn, manager, chunkPos)) return false;
            if (Math.abs(this.y - worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.x + (this.direction.func_176740_k().equals((Object)Direction.Axis.X) ? (this.direction.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? -3 : 3) : 0), this.z + (this.direction.func_176740_k().equals((Object)Direction.Axis.Z) ? (this.direction.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? -3 : 3) : 0))) >= 3) return false;
            return true;
        }
    }

    public static class Tent
    extends HunterCampPieces {
        private final Direction direction;
        private final boolean advanced;
        int xDiff;
        int xCenter;
        private int mirror;

        public Tent(int x, int y, int z, Direction direction, Block baseBlock, boolean advanced) {
            super(ModFeatures.hunter_camp_tent, 1, x, y, z, baseBlock);
            this.func_186164_a(direction);
            this.direction = direction;
            this.advanced = advanced;
        }

        public Tent(TemplateManager templateManager, CompoundNBT nbt) {
            super(ModFeatures.hunter_camp_tent, nbt);
            this.direction = Direction.func_176731_b((int)nbt.func_74762_e("direction"));
            this.mirror = nbt.func_74762_e("mirror");
            this.advanced = nbt.func_74767_n("advanced");
        }

        @Override
        public boolean func_230383_a_(ISeedReader worldIn, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos, BlockPos blockPos) {
            BlockPos pos4;
            BlockPos pos3;
            BlockPos pos2;
            BlockPos pos1;
            int d;
            int c;
            int b;
            int a;
            if (this.mirror == 0 ? (this.mirror = random.nextInt(2) + 1) == 1 : this.mirror == 1) {
                this.xDiff = 2;
                this.xCenter = this.x + 1;
            } else {
                this.xDiff = 0;
                this.xCenter = this.x - 1;
            }
            if (!super.func_230383_a_(worldIn, structureManager, chunkGenerator, random, structureBoundingBoxIn, chunkPos, blockPos)) {
                return false;
            }
            Direction dir = this.direction == Direction.SOUTH || this.direction == Direction.WEST ? this.direction.func_176734_d() : this.direction;
            int nul = this.direction.func_176736_b() % 4;
            int one = (this.direction.func_176736_b() + 1) % 4;
            int two = (this.direction.func_176736_b() + 2) % 4;
            int three = (this.direction.func_176736_b() + 3) % 4;
            boolean positiveAxisDirection = this.direction.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE);
            boolean xAxis = this.direction.func_176740_k().equals((Object)Direction.Axis.X);
            int n = positiveAxisDirection ? one : (a = xAxis ? nul : two);
            int n2 = !positiveAxisDirection ? three : (b = xAxis ? two : nul);
            int n3 = positiveAxisDirection ? three : (c = xAxis ? two : nul);
            int n4 = !positiveAxisDirection ? one : (d = xAxis ? nul : two);
            if (this.mirror == 1) {
                this.func_175811_a(worldIn, (BlockState)((BlockState)((TentBlock)ModBlocks.TENT.get()).func_176223_P().func_206870_a((Property)TentBlock.FACING, (Comparable)dir.func_176734_d())).func_206870_a((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(a)), this.xDiff, 0, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (BlockState)((BlockState)((TentBlock)ModBlocks.TENT.get()).func_176223_P().func_206870_a((Property)TentBlock.FACING, (Comparable)dir)).func_206870_a((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(b)), 1, 0, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (BlockState)((BlockState)((TentMainBlock)ModBlocks.TENT_MAIN.get()).func_176223_P().func_206870_a((Property)TentBlock.FACING, (Comparable)dir)).func_206870_a((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(c)), 1, 0, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (BlockState)((BlockState)((TentBlock)ModBlocks.TENT.get()).func_176223_P().func_206870_a((Property)TentBlock.FACING, (Comparable)dir.func_176734_d())).func_206870_a((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(d)), this.xDiff, 0, 1, structureBoundingBoxIn);
            } else {
                this.func_175811_a(worldIn, (BlockState)((BlockState)((TentBlock)ModBlocks.TENT.get()).func_176223_P().func_206870_a((Property)TentBlock.FACING, (Comparable)dir)).func_206870_a((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(b)), this.xDiff, 0, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (BlockState)((BlockState)((TentBlock)ModBlocks.TENT.get()).func_176223_P().func_206870_a((Property)TentBlock.FACING, (Comparable)dir.func_176734_d())).func_206870_a((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(a)), 1, 0, 0, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (BlockState)((BlockState)((TentMainBlock)ModBlocks.TENT_MAIN.get()).func_176223_P().func_206870_a((Property)TentBlock.FACING, (Comparable)dir.func_176734_d())).func_206870_a((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(d)), 1, 0, 1, structureBoundingBoxIn);
                this.func_175811_a(worldIn, (BlockState)((BlockState)((TentBlock)ModBlocks.TENT.get()).func_176223_P().func_206870_a((Property)TentBlock.FACING, (Comparable)dir)).func_206870_a((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(c)), this.xDiff, 0, 1, structureBoundingBoxIn);
            }
            TileEntity tile = worldIn.func_175625_s(new BlockPos(this.x, this.y, this.z));
            if (tile instanceof TentTileEntity) {
                ((TentTileEntity)tile).setSpawn(true);
                if (this.advanced) {
                    ((TentTileEntity)tile).setAdvanced(true);
                }
            }
            if (worldIn.func_180495_p(pos1 = new BlockPos(this.xCenter, this.y - 1, this.z - 1)).func_185904_a().func_76222_j()) {
                this.func_175811_a(worldIn, this.baseBlock.func_176223_P(), this.xDiff, -1, 0, structureBoundingBoxIn);
            }
            if (worldIn.func_180495_p(pos2 = new BlockPos(this.x, this.y - 1, this.z - 1)).func_185904_a().func_76222_j()) {
                this.func_175811_a(worldIn, this.baseBlock.func_176223_P(), 1, -1, 0, structureBoundingBoxIn);
            }
            if (worldIn.func_180495_p(pos3 = new BlockPos(this.x, this.y - 1, this.z)).func_185904_a().func_76222_j()) {
                this.func_175811_a(worldIn, this.baseBlock.func_176223_P(), 1, -1, 1, structureBoundingBoxIn);
            }
            if (worldIn.func_180495_p(pos4 = new BlockPos(this.xCenter, this.y - 1, this.z)).func_185904_a().func_76222_j()) {
                this.func_175811_a(worldIn, this.baseBlock.func_176223_P(), this.xDiff, -1, 1, structureBoundingBoxIn);
            }
            BlockState air = Blocks.field_150350_a.func_176223_P();
            this.func_175811_a(worldIn, air, 1, 0, -1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, air, this.xDiff, 0, -1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, air, 1, 1, -1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, air, this.xDiff, 1, -1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, air, this.xDiff, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, air, 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, air, 1, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, air, this.xDiff, 1, 1, structureBoundingBoxIn);
            if (Tags.Blocks.DIRT.func_230235_a_((Object)worldIn.func_180495_p(new BlockPos(this.x, this.y - 1, this.z - 2)).func_177230_c())) {
                this.func_175811_a(worldIn, Blocks.field_196658_i.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
            }
            if (Tags.Blocks.DIRT.func_230235_a_((Object)worldIn.func_180495_p(new BlockPos(this.xCenter, this.y - 1, this.z - 2)).func_177230_c())) {
                this.func_175811_a(worldIn, Blocks.field_196658_i.func_176223_P(), this.xDiff, -1, -1, structureBoundingBoxIn);
            }
            return true;
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74768_a("direction", this.direction.func_176736_b());
            tagCompound.func_74768_a("mirror", this.mirror);
            tagCompound.func_74757_a("advanced", this.advanced);
            super.func_143011_b(tagCompound);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean testPreconditions(ISeedReader worldIn, StructureManager manager, ChunkPos chunkPos) {
            if (!super.testPreconditions(worldIn, manager, chunkPos)) return false;
            if (worldIn.func_180495_p(new BlockPos(this.xCenter, this.y - 1, this.z - 1)).func_185904_a().func_76224_d()) return false;
            if (worldIn.func_180495_p(new BlockPos(this.x, this.y - 1, this.z - 1)).func_185904_a().func_76224_d()) return false;
            if (worldIn.func_180495_p(new BlockPos(this.xCenter, this.y - 1, this.z)).func_185904_a().func_76224_d()) return false;
            if (Math.abs(this.y - worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.x + (this.direction.func_176740_k().equals((Object)Direction.Axis.X) ? (this.direction.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? -3 : 3) : 0), this.z + (this.direction.func_176740_k().equals((Object)Direction.Axis.Z) ? (this.direction.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? -3 : 3) : 0))) >= 2) return false;
            return true;
        }
    }

    public static class Fireplace
    extends HunterCampPieces {
        boolean specialComponentAdd = false;
        private boolean advanced;

        public Fireplace(Random random, int x, int y, int z, Block baseBlock) {
            super(ModFeatures.hunter_camp_fireplace, 0, x, y, z, baseBlock);
            this.func_186164_a(Direction.Plane.HORIZONTAL.func_179518_a(random));
        }

        public Fireplace(TemplateManager templateManager, CompoundNBT nbt) {
            super(ModFeatures.hunter_camp_fireplace, nbt);
            this.advanced = nbt.func_74767_n("advanced");
            this.specialComponentAdd = nbt.func_74767_n("specialComponentAdd");
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            ArrayList directions = Lists.newArrayList((Object[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
            if (rand.nextInt(3) == 0) {
                this.advanced = true;
                listIn.add(this.getTentComponent(rand, directions, true));
                listIn.add(this.getTentComponent(rand, directions, false));
                int i = rand.nextInt(4);
                if (i < 2) {
                    listIn.add(this.getComponent(rand, directions, true));
                }
                if (i < 1) {
                    listIn.add(this.getComponent(rand, directions, true));
                }
            } else {
                listIn.add(this.getTentComponent(rand, directions, false));
                if (rand.nextInt(2) == 0) {
                    listIn.add(this.getComponent(rand, directions, false));
                }
            }
        }

        @Override
        public boolean func_230383_a_(ISeedReader worldIn, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos, BlockPos blockPos) {
            if (!super.func_230383_a_(worldIn, structureManager, chunkGenerator, random, structureBoundingBoxIn, chunkPos, blockPos)) {
                return false;
            }
            this.func_175811_a(worldIn, (Boolean)VampirismConfig.COMMON.useVanillaCampfire.get() != false ? Blocks.field_222433_lV.func_176223_P() : ((FirePlaceBlock)ModBlocks.FIRE_PLACE.get()).func_176223_P(), 1, 0, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 1, structureBoundingBoxIn);
            return true;
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("advanced", this.advanced);
            tagCompound.func_74757_a("specialComponentAdd", this.specialComponentAdd);
        }

        private StructurePiece getComponent(Random rand, List<Direction> directions, boolean advanced) {
            Direction direction = directions.remove(rand.nextInt(directions.size()));
            int x = this.x + (direction.func_176740_k().equals((Object)Direction.Axis.X) ? (direction.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : 0);
            int z = this.z + (direction.func_176740_k().equals((Object)Direction.Axis.Z) ? (direction.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : 0);
            if (!this.specialComponentAdd && rand.nextInt(2) == 0) {
                this.specialComponentAdd = true;
                return new SpecialBlock(x, this.y, z, direction, this.baseBlock, advanced);
            }
            return new Tent(x, this.y, z, direction, this.baseBlock, advanced);
        }

        private StructurePiece getTentComponent(Random rand, List<Direction> directions, boolean advanced) {
            Direction direction = directions.remove(rand.nextInt(directions.size()));
            int x = this.x + (direction.func_176740_k().equals((Object)Direction.Axis.X) ? (direction.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : 0);
            int z = this.z + (direction.func_176740_k().equals((Object)Direction.Axis.Z) ? (direction.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : 0);
            return new Tent(x, this.y, z, direction, this.baseBlock, advanced);
        }
    }
}

