/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonObject;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.util.OilUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class SmeltItemLootModifier
extends LootModifier {
    protected SmeltItemLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack entityStack;
        ItemStack stack = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (!(entity instanceof LivingEntity) || stack == null || !OilUtils.getAppliedOil(stack).filter(oil -> oil == ModOils.SMELT.get()).isPresent()) {
            return generatedLoot;
        }
        stack = entityStack = ((LivingEntity)entity).func_184614_ca();
        OilUtils.reduceAppliedOilDuration(stack);
        return this.trySmelting(generatedLoot, context.func_202879_g());
    }

    private List<ItemStack> trySmelting(List<ItemStack> generatedLoot, ServerWorld level) {
        RecipeManager recipeManager = level.func_199532_z();
        return generatedLoot.stream().map(stack -> recipeManager.func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), (World)level).map(AbstractCookingRecipe::func_77571_b).filter(result -> !result.func_190926_b()).orElse((ItemStack)stack)).collect(Collectors.toList());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SmeltItemLootModifier> {
        public SmeltItemLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            return new SmeltItemLootModifier(ailootcondition);
        }

        public JsonObject write(SmeltItemLootModifier instance) {
            return null;
        }
    }
}

