/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.wallets;

import de.cheaterpaul.wallets.client.core.ModScreens;
import de.cheaterpaul.wallets.config.Config;
import de.cheaterpaul.wallets.data.ItemModelGenerator;
import de.cheaterpaul.wallets.data.RecipeGenerator;
import de.cheaterpaul.wallets.inventory.WalletContainer;
import de.cheaterpaul.wallets.items.CoinItem;
import de.cheaterpaul.wallets.items.CoinPouchItem;
import de.cheaterpaul.wallets.items.WalletItem;
import de.cheaterpaul.wallets.network.ModPacketDispatcher;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="wallets")
public class WalletsMod {
    public static final ModPacketDispatcher dispatcher = new ModPacketDispatcher();
    public static final ItemGroup ITEM_GROUP = new ItemGroup("wallets"){

        @Nonnull
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)wallet_item);
        }
    };
    @ObjectHolder(value="wallets:coin_one")
    public static final CoinItem coin_one = (CoinItem)WalletsMod.getNull();
    @ObjectHolder(value="wallets:wallet")
    public static final WalletItem wallet_item = (WalletItem)WalletsMod.getNull();
    @ObjectHolder(value="wallets:coin_pouch")
    public static final CoinPouchItem coin_pouch = (CoinPouchItem)WalletsMod.getNull();
    @ObjectHolder(value="wallets:wallet")
    public static final ContainerType<WalletContainer> wallet_container = (ContainerType)WalletsMod.getNull();

    public WalletsMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::gatherData);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.init();
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new ItemModelGenerator(gen, event.getExistingFileHelper()));
        }
        gen.func_200390_a((IDataProvider)new RecipeGenerator(gen));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModScreens::registerScreens);
    }

    private void setup(FMLCommonSetupEvent event) {
        dispatcher.registerPackets();
    }

    @Nonnull
    public static <T> T getNull() {
        return null;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register(new CoinItem(CoinItem.CoinValue.ONE, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName("wallets", "coin_one"));
            registry.register(new CoinItem(CoinItem.CoinValue.FIVE, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName("wallets", "coin_five"));
            registry.register(new CoinItem(CoinItem.CoinValue.TWENTY, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName("wallets", "coin_twenty"));
            registry.register(new CoinItem(CoinItem.CoinValue.FIFTY, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName("wallets", "coin_fifty"));
            registry.register(new CoinItem(CoinItem.CoinValue.ONE_HUNDRED, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName("wallets", "coin_one_hundred"));
            registry.register(new CoinItem(CoinItem.CoinValue.FIVE_HUNDRED, new Item.Properties().func_200916_a(ITEM_GROUP)).setRegistryName("wallets", "coin_five_hundred"));
            registry.register(new CoinPouchItem(new Item.Properties().func_200916_a(ITEM_GROUP).func_200917_a(1)).setRegistryName("wallets", "coin_pouch"));
            registry.register(new WalletItem(new Item.Properties().func_200916_a(ITEM_GROUP).func_200917_a(1)).setRegistryName("wallets", "wallet"));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register(new ContainerType(WalletContainer::new).setRegistryName("wallets", "wallet"));
        }
    }
}

