/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.wallets.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.cheaterpaul.wallets.WalletsMod;
import de.cheaterpaul.wallets.config.Config;
import de.cheaterpaul.wallets.inventory.ICoinChangeListener;
import de.cheaterpaul.wallets.inventory.WalletContainer;
import de.cheaterpaul.wallets.items.CoinItem;
import de.cheaterpaul.wallets.items.ICoinContainer;
import de.cheaterpaul.wallets.network.InputEventPacket;
import de.cheaterpaul.wallets.network.TakeCoinPacket;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class WalletScreen
extends ContainerScreen<WalletContainer>
implements ICoinChangeListener {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("wallets", "textures/gui/wallet.png");
    private TextFieldWidget sumField;
    private TextFieldWidget walletSum;

    public WalletScreen(WalletContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147000_g = 177;
        this.field_146999_f = 188;
        this.field_238745_s_ = this.field_147000_g - 94;
        this.field_238744_r_ = 14;
        ((WalletContainer)this.field_147002_h).listen(this);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new ImageButton(this.getGuiLeft() + 18, this.getGuiTop() + 37, 11, 7, 202, 0, 7, BACKGROUND, 256, 256, this::walletApplyPressed, new Button.ITooltip(){

            public void onTooltip(@Nonnull Button button, @Nonnull MatrixStack stack, int mouseX, int mouseY) {
                ItemStack itemstack = ((Slot)((WalletContainer)((WalletScreen)WalletScreen.this).field_147002_h).field_75151_b.get((int)0)).field_75224_c.func_70301_a(0);
                int amount = 0;
                if (itemstack.func_77973_b() instanceof ICoinContainer) {
                    amount = ((ICoinContainer)itemstack.func_77973_b()).getCoins(itemstack);
                }
                TranslationTextComponent text = new TranslationTextComponent("text.wallets.transfer", new Object[]{amount});
                if (((WalletContainer)WalletScreen.this.field_147002_h).getWalletAmount() + amount > 999999999) {
                    text = new TranslationTextComponent("text.wallets.wallet_full").func_240699_a_(TextFormatting.RED);
                }
                WalletScreen.this.func_238652_a_(stack, (ITextComponent)text, mouseX, mouseY);
            }
        }, StringTextComponent.field_240750_d_));
        this.func_230480_a_((Widget)new AddWalletButton(this.getGuiLeft() + 52 + 20, this.getGuiTop() + 43, 14, 14, 188, 0, 14, BACKGROUND, 256, 256, this::walletTakeCoinPressed, (button, stack, mouseX, mouseY) -> this.toolTip(button, stack, mouseX, mouseY, CoinItem.CoinValue.ONE), StringTextComponent.field_240750_d_, CoinItem.CoinValue.ONE));
        this.func_230480_a_((Widget)new AddWalletButton(this.getGuiLeft() + 70 + 20, this.getGuiTop() + 43, 14, 14, 188, 0, 14, BACKGROUND, 256, 256, this::walletTakeCoinPressed, (button, stack, mouseX, mouseY) -> this.toolTip(button, stack, mouseX, mouseY, CoinItem.CoinValue.FIVE), StringTextComponent.field_240750_d_, CoinItem.CoinValue.FIVE));
        this.func_230480_a_((Widget)new AddWalletButton(this.getGuiLeft() + 88 + 20, this.getGuiTop() + 43, 14, 14, 188, 0, 14, BACKGROUND, 256, 256, this::walletTakeCoinPressed, (button, stack, mouseX, mouseY) -> this.toolTip(button, stack, mouseX, mouseY, CoinItem.CoinValue.TWENTY), StringTextComponent.field_240750_d_, CoinItem.CoinValue.TWENTY));
        this.func_230480_a_((Widget)new AddWalletButton(this.getGuiLeft() + 106 + 20, this.getGuiTop() + 43, 14, 14, 188, 0, 14, BACKGROUND, 256, 256, this::walletTakeCoinPressed, (button, stack, mouseX, mouseY) -> this.toolTip(button, stack, mouseX, mouseY, CoinItem.CoinValue.FIFTY), StringTextComponent.field_240750_d_, CoinItem.CoinValue.FIFTY));
        this.func_230480_a_((Widget)new AddWalletButton(this.getGuiLeft() + 124 + 20, this.getGuiTop() + 43, 14, 14, 188, 0, 14, BACKGROUND, 256, 256, this::walletTakeCoinPressed, (button, stack, mouseX, mouseY) -> this.toolTip(button, stack, mouseX, mouseY, CoinItem.CoinValue.ONE_HUNDRED), StringTextComponent.field_240750_d_, CoinItem.CoinValue.ONE_HUNDRED));
        this.func_230480_a_((Widget)new AddWalletButton(this.getGuiLeft() + 142 + 20, this.getGuiTop() + 43, 14, 14, 188, 0, 14, BACKGROUND, 256, 256, this::walletTakeCoinPressed, (button, stack, mouseX, mouseY) -> this.toolTip(button, stack, mouseX, mouseY, CoinItem.CoinValue.FIVE_HUNDRED), StringTextComponent.field_240750_d_, CoinItem.CoinValue.FIVE_HUNDRED));
        this.func_230480_a_((Widget)new ImageButton(this.getGuiLeft() + 142 + 2, this.getGuiTop() + 16, 14, 14, 188, 0, 14, BACKGROUND, 256, 256, this::walletSumCoinsPressed, (button, stack, mouseX, mouseY) -> this.getSum().ifPresent(value -> this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("text.wallets.take", new Object[]{value}), mouseX, mouseY)), StringTextComponent.field_240750_d_));
        if (!((Boolean)Config.CONFIG.disableCoinPouch.get()).booleanValue()) {
            this.func_230480_a_((Widget)new ImageButton(this.getGuiLeft() + 162, this.getGuiTop() + 16, 14, 14, 213, 0, 14, BACKGROUND, 256, 256, this::walletCreateCoinPoach, (button, stack, mouseX, mouseY) -> this.getSum().ifPresent(value -> this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("text.wallets.create_pouch", new Object[]{value}), mouseX, mouseY)), StringTextComponent.field_240750_d_));
        }
        this.sumField = new NumberOnlyTextFieldWidget(this.field_230712_o_, this.field_147003_i + 52, this.field_147009_r + 19, 84, 9, (ITextComponent)new TranslationTextComponent("text.wallets.take_coin_sum"));
        this.sumField.func_146203_f(13);
        this.sumField.func_146180_a("");
        this.sumField.func_146185_a(false);
        this.func_212928_a((IGuiEventListener)this.sumField);
        this.func_230481_d_((IGuiEventListener)this.sumField);
        this.walletSum = new NoEditTextFieldWidget(this.field_230712_o_, this.field_147003_i + 8, this.field_147009_r + 63, 55, 10, (ITextComponent)new TranslationTextComponent("text.wallets.wallet_sum"));
        this.walletSum.func_146203_f(10);
        this.walletSum.func_146185_a(false);
        this.walletSum.func_146184_c(false);
        this.walletSum.func_146204_h(0xE0E0E0);
        this.walletSum.func_146180_a(String.valueOf(((WalletContainer)this.field_147002_h).getWalletAmount()));
        this.func_230481_d_((IGuiEventListener)this.walletSum);
    }

    public void func_231152_a_(@Nonnull Minecraft minecraft, int xSize, int ySize) {
        String walletAmount = this.walletSum.func_146179_b();
        String sumAmount = this.sumField.func_146179_b();
        super.func_231152_a_(minecraft, xSize, ySize);
        this.walletSum.func_146180_a(walletAmount);
        this.sumField.func_146180_a(sumAmount);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.sumField.func_146178_a();
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        return super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    private void walletApplyPressed(Button b) {
        WalletsMod.dispatcher.sentToServer(new InputEventPacket("ic"));
    }

    private void walletTakeCoinPressed(Button b) {
        AddWalletButton button = (AddWalletButton)b;
        WalletsMod.dispatcher.sentToServer(new TakeCoinPacket(button.getValue(), WalletScreen.func_231173_s_() ? 64 : 1));
    }

    private void walletSumCoinsPressed(Button b) {
        this.getSum().ifPresent(value -> {
            if (value <= (long)((WalletContainer)this.field_147002_h).getWalletAmount()) {
                WalletsMod.dispatcher.sentToServer(new InputEventPacket("tcs", value.toString()));
            }
        });
    }

    public void func_238746_a_(@Nonnull MatrixStack stack, @Nonnull Slot slot) {
        if (slot instanceof WalletContainer.TakeOnlySlot) {
            RenderSystem.enableDepthTest();
            RenderSystem.enableTexture();
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.field_230706_i_.func_228015_a_(PlayerContainer.field_226615_c_).apply(((WalletContainer.TakeOnlySlot)slot).getTexture());
            this.field_230706_i_.func_110434_K().func_110577_a(sprite.func_229241_m_().func_229223_g_());
            WalletScreen.func_238470_a_((MatrixStack)stack, (int)slot.field_75223_e, (int)slot.field_75221_f, (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)sprite);
        }
        super.func_238746_a_(stack, slot);
    }

    private void walletCreateCoinPoach(Button b) {
        this.getSum().ifPresent(value -> {
            if (value <= (long)((WalletContainer)this.field_147002_h).getWalletAmount()) {
                WalletsMod.dispatcher.sentToServer(new InputEventPacket("cp", value.toString()));
            }
        });
    }

    private Optional<Long> getSum() {
        try {
            String val = this.sumField.func_146179_b();
            long value = val.equals("") ? 0L : Long.parseLong(val);
            return Optional.of(value);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private void toolTip(Button button, MatrixStack stack, int mouseX, int mouseY, CoinItem.CoinValue amount) {
        this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("text.wallets.take", new Object[]{amount.getValue()}), mouseX, mouseY);
    }

    protected void func_230450_a_(@Nonnull MatrixStack stack, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        WalletScreen.func_238464_a_((MatrixStack)stack, (int)this.getGuiLeft(), (int)this.getGuiTop(), (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)this.getXSize(), (int)this.getYSize(), (int)256, (int)256);
    }

    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.walletSum.func_146180_a(String.valueOf(((WalletContainer)this.field_147002_h).getWalletAmount()));
        this.walletSum.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.sumField.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    @Override
    public void coinsChanged() {
        this.walletSum.func_146180_a(String.valueOf(((WalletContainer)this.field_147002_h).getWalletAmount()));
    }

    private class NumberOnlyTextFieldWidget
    extends TextFieldWidget {
        public NumberOnlyTextFieldWidget(FontRenderer p_i232260_1_, int p_i232260_2_, int p_i232260_3_, int p_i232260_4_, int p_i232260_5_, ITextComponent p_i232260_6_) {
            super(p_i232260_1_, p_i232260_2_, p_i232260_3_, p_i232260_4_, p_i232260_5_, p_i232260_6_);
        }

        public NumberOnlyTextFieldWidget(FontRenderer p_i232259_1_, int p_i232259_2_, int p_i232259_3_, int p_i232259_4_, @Nullable int p_i232259_5_, TextFieldWidget p_i232259_6_, ITextComponent p_i232259_7_) {
            super(p_i232259_1_, p_i232259_2_, p_i232259_3_, p_i232259_4_, p_i232259_5_, p_i232259_6_, p_i232259_7_);
        }

        public void func_146191_b(@Nonnull String input) {
            try {
                int value = Integer.parseInt(input);
                super.func_146191_b(input);
                if (Long.parseLong(this.func_146179_b()) > (long)((WalletContainer)WalletScreen.this.field_147002_h).getWalletAmount()) {
                    this.func_146193_g(0xFF5555);
                } else {
                    this.func_146193_g(0xE0E0E0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void func_146175_b(int p_146175_1_) {
            super.func_146175_b(p_146175_1_);
            try {
                if (Long.parseLong(this.func_146179_b()) > (long)((WalletContainer)WalletScreen.this.field_147002_h).getWalletAmount()) {
                    this.func_146193_g(0xFF5555);
                } else {
                    this.func_146193_g(0xE0E0E0);
                }
            }
            catch (NumberFormatException ignored) {
                this.func_146193_g(0xE0E0E0);
            }
        }

        public void func_146177_a(int p_146177_1_) {
            super.func_146177_a(p_146177_1_);
            try {
                if (Long.parseLong(this.func_146179_b()) > (long)((WalletContainer)WalletScreen.this.field_147002_h).getWalletAmount()) {
                    this.func_146193_g(0xFF5555);
                } else {
                    this.func_146193_g(0xE0E0E0);
                }
            }
            catch (NumberFormatException ignored) {
                this.func_146193_g(0xE0E0E0);
            }
        }
    }

    public static class NoEditTextFieldWidget
    extends TextFieldWidget {
        public NoEditTextFieldWidget(FontRenderer p_i232260_1_, int p_i232260_2_, int p_i232260_3_, int p_i232260_4_, int p_i232260_5_, ITextComponent p_i232260_6_) {
            super(p_i232260_1_, p_i232260_2_, p_i232260_3_, p_i232260_4_, p_i232260_5_, p_i232260_6_);
        }

        public NoEditTextFieldWidget(FontRenderer p_i232259_1_, int p_i232259_2_, int p_i232259_3_, int p_i232259_4_, int p_i232259_5_, @Nullable TextFieldWidget p_i232259_6_, ITextComponent p_i232259_7_) {
            super(p_i232259_1_, p_i232259_2_, p_i232259_3_, p_i232259_4_, p_i232259_5_, p_i232259_6_, p_i232259_7_);
        }

        public boolean func_230999_j_() {
            return false;
        }
    }

    private static class AddWalletButton
    extends ImageButton {
        private final CoinItem.CoinValue value;

        public AddWalletButton(int xPos, int yPos, int xSize, int ySize, int xTexPos, int yTexPos, int yTexDiff, ResourceLocation texture, Button.IPressable pressable, CoinItem.CoinValue value) {
            super(xPos, yPos, xSize, ySize, xTexPos, yTexPos, yTexDiff, texture, pressable);
            this.value = value;
        }

        public AddWalletButton(int xPos, int yPos, int xSize, int ySize, int xTexPos, int yTexPos, int yTexDiff, ResourceLocation texture, int textureWidth, int textureHeight, Button.IPressable pressable, CoinItem.CoinValue value) {
            super(xPos, yPos, xSize, ySize, xTexPos, yTexPos, yTexDiff, texture, textureWidth, textureHeight, pressable);
            this.value = value;
        }

        public AddWalletButton(int xPos, int yPos, int xSize, int ySize, int xTexPos, int yTexPos, int yTexDiff, ResourceLocation texture, int textureWidth, int textureHeight, Button.IPressable pressable, ITextComponent name, CoinItem.CoinValue value) {
            super(xPos, yPos, xSize, ySize, xTexPos, yTexPos, yTexDiff, texture, textureWidth, textureHeight, pressable, name);
            this.value = value;
        }

        public AddWalletButton(int xPos, int yPos, int xSize, int ySize, int xTexPos, int yTexPos, int yTexDiff, ResourceLocation texture, int textureWidth, int textureHeight, Button.IPressable pressable, Button.ITooltip tooltip, ITextComponent name, CoinItem.CoinValue value) {
            super(xPos, yPos, xSize, ySize, xTexPos, yTexPos, yTexDiff, texture, textureWidth, textureHeight, pressable, tooltip, name);
            this.value = value;
        }

        public CoinItem.CoinValue getValue() {
            return this.value;
        }
    }
}

