/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.wallets.inventory;

import de.cheaterpaul.wallets.WalletsMod;
import de.cheaterpaul.wallets.inventory.ICoinChangeListener;
import de.cheaterpaul.wallets.items.CoinItem;
import de.cheaterpaul.wallets.items.CoinPouchItem;
import de.cheaterpaul.wallets.items.ICoinContainer;
import de.cheaterpaul.wallets.items.WalletItem;
import de.cheaterpaul.wallets.network.UpdateWalletPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class WalletContainer
extends Container {
    protected final IInventory inventory;
    private final ItemStack walletStack;
    private int walletAmount;
    private int walletPos;
    private final PlayerEntity player;
    private final Map<CoinItem.CoinValue, TakeOnlySlot> coinSlots;
    private ICoinChangeListener changeListener;

    @Deprecated
    public WalletContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, ItemStack.field_190927_a);
    }

    public WalletContainer(int id, PlayerInventory playerInventory, ItemStack stack) {
        super(WalletsMod.wallet_container, id);
        this.player = playerInventory.field_70458_d;
        this.walletStack = stack;
        this.inventory = new Inventory(7);
        this.coinSlots = new HashMap<CoinItem.CoinValue, TakeOnlySlot>();
        this.addSlots(this.inventory);
        this.addPlayerSlots(playerInventory);
        this.walletAmount = WalletItem.getCoinValue(stack);
        if (!this.player.field_70170_p.field_72995_K) {
            this.walletPos = playerInventory.func_194014_c(stack);
        }
    }

    public void listen(ICoinChangeListener listener) {
        this.changeListener = listener;
    }

    public int getWalletAmount() {
        return this.walletAmount;
    }

    protected void addSlots(IInventory inventory) {
        this.func_75146_a(new CoinSlot(inventory, 0, 15, 15, stack -> stack.func_77973_b() instanceof ICoinContainer));
        this.func_75146_a(new TakeOnlySlot(CoinItem.CoinValue.ONE, inventory, 1, 71, 60, new ResourceLocation("wallets", "item/coin_one")));
        this.func_75146_a(new TakeOnlySlot(CoinItem.CoinValue.FIVE, inventory, 2, 89, 60, new ResourceLocation("wallets", "item/coin_five")));
        this.func_75146_a(new TakeOnlySlot(CoinItem.CoinValue.TWENTY, inventory, 3, 107, 60, new ResourceLocation("wallets", "item/coin_twenty")));
        this.func_75146_a(new TakeOnlySlot(CoinItem.CoinValue.FIFTY, inventory, 4, 125, 60, new ResourceLocation("wallets", "item/coin_fifty")));
        this.func_75146_a(new TakeOnlySlot(CoinItem.CoinValue.ONE_HUNDRED, inventory, 5, 143, 60, new ResourceLocation("wallets", "item/coin_one_hundred")));
        this.func_75146_a(new TakeOnlySlot(CoinItem.CoinValue.FIVE_HUNDRED, inventory, 6, 161, 60, new ResourceLocation("wallets", "item/coin_five_hundred")));
    }

    protected void addPlayerSlots(PlayerInventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 14 + j * 18, 95 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new WalletSafeSlot((IInventory)playerInventory, k, 14 + k * 18, 153));
        }
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity playerEntity, int index) {
        int size = this.inventory.func_70302_i_();
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            result = slotStack.func_77946_l();
            if (index < size) {
                if (!this.func_75135_a(slotStack, size, 36 + size, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index < 27 + size) {
                if (!this.func_75135_a(slotStack, 0, size, false) && slotStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(slotStack, 27 + size, 36 + size, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 27 + size && index < 36 + size && !this.func_75135_a(slotStack, 0, 27 + size, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, slotStack);
        }
        return result;
    }

    public void insertCoin() {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = this.inventory.func_70301_a(0);
        if (!stack.func_190926_b()) {
            int coin_value = ((ICoinContainer)stack.func_77973_b()).getCoins(stack);
            if (this.getWalletAmount() + coin_value > 999999999) {
                return;
            }
            if (((ICoinContainer)stack.func_77973_b()).containsCoins()) {
                ((ICoinContainer)stack.func_77973_b()).clear(stack);
            } else if (((ICoinContainer)stack.func_77973_b()).removedOnUsage()) {
                this.inventory.func_70299_a(0, ItemStack.field_190927_a);
            }
            this.addWalletCoins(coin_value);
        }
    }

    public void updateClient() {
        if (!(this.player instanceof ServerPlayerEntity)) {
            return;
        }
        WalletsMod.dispatcher.sentToPlayer(new UpdateWalletPacket(this.walletAmount, this.walletPos), (ServerPlayerEntity)this.player);
    }

    public void takeCoin(CoinItem.CoinValue value) {
        this.takeCoin(value, 1);
    }

    public void takeCoin(CoinItem.CoinValue type, int amount) {
        assert (amount <= 64);
        int coinValue = type.getValue();
        int coins = Math.min(WalletItem.getCoinValue(this.walletStack) / coinValue, amount);
        ItemStack slot = this.coinSlots.get((Object)type).func_75211_c();
        coins = Math.min(coins, slot.func_77976_d() - slot.func_190916_E());
        this._takeCoin(type, coins);
        this.addWalletCoins(-coins * coinValue);
    }

    private void _takeCoin(CoinItem.CoinValue value, int amount) {
        if (amount <= 0) {
            return;
        }
        ItemStack stack = this.inventory.func_70301_a(value.ordinal() + 1);
        if (stack.func_190926_b()) {
            this.inventory.func_70299_a(value.ordinal() + 1, new ItemStack((IItemProvider)CoinItem.getCoin(value), amount));
        } else {
            stack.func_190917_f(amount);
        }
    }

    public void takeCoins(int value) {
        if (value <= 0) {
            return;
        }
        if (value > WalletItem.getCoinValue(this.walletStack)) {
            value = WalletItem.getCoinValue(this.walletStack);
        }
        int remaining = value;
        for (int i = CoinItem.CoinValue.values().length - 1; i >= 0; --i) {
            CoinItem.CoinValue v = CoinItem.CoinValue.values()[i];
            int amount = remaining / v.getValue();
            remaining -= amount * v.getValue();
            while (amount > 0) {
                CoinItem item = CoinItem.getCoin(v);
                int stackSize = MathHelper.func_76125_a((int)amount, (int)0, (int)item.func_77639_j());
                amount -= stackSize;
                this.player.field_71071_by.func_191975_a(this.player.field_70170_p, new ItemStack((IItemProvider)item, stackSize));
            }
        }
        this.addWalletCoins(-value);
    }

    public void createPouch(int value) {
        if (value > WalletItem.getCoinValue(this.walletStack)) {
            value = WalletItem.getCoinValue(this.walletStack);
        }
        if (value <= 0) {
            return;
        }
        ItemStack stack = CoinPouchItem.createPouch(value);
        this.addWalletCoins(-value);
        this.player.field_71071_by.func_191975_a(this.player.field_70170_p, stack);
    }

    private void addWalletCoins(int amount) {
        WalletItem.setCoinValue(this.walletStack, WalletItem.getCoinValue(this.walletStack) + amount);
        this.walletAmount = WalletItem.getCoinValue(this.walletStack);
        this.updateClient();
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        super.func_75134_a(player);
        this.func_193327_a(player, player.field_70170_p, this.inventory);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity p_75145_1_) {
        return true;
    }

    public void update(UpdateWalletPacket msg) {
        this.walletAmount = msg.walletAmount;
        this.walletPos = msg.walletPos;
        if (this.changeListener != null) {
            this.changeListener.coinsChanged();
        }
    }

    public class TakeOnlySlot
    extends Slot {
        private ResourceLocation texture;

        public TakeOnlySlot(CoinItem.CoinValue coin, IInventory p_i1824_1_, int p_i1824_2_, int p_i1824_3_, int p_i1824_4_, ResourceLocation texture) {
            super(p_i1824_1_, p_i1824_2_, p_i1824_3_, p_i1824_4_);
            this.texture = texture;
            WalletContainer.this.coinSlots.put(coin, this);
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }

    public static class CoinSlot
    extends Slot {
        private final Predicate<ItemStack> predicate;

        public CoinSlot(IInventory inventory, int slot, int xPos, int yPos, Predicate<ItemStack> predicate) {
            super(inventory, slot, xPos, yPos);
            this.predicate = predicate;
        }

        public boolean func_75214_a(@Nonnull ItemStack itemStack) {
            return this.predicate.test(itemStack);
        }
    }

    public class WalletSafeSlot
    extends Slot {
        public WalletSafeSlot(IInventory inventory, int slot, int xPos, int yPos) {
            super(inventory, slot, xPos, yPos);
        }

        public boolean func_82869_a(@Nonnull PlayerEntity player) {
            return WalletContainer.this.walletPos != this.getSlotIndex();
        }

        public void func_75218_e() {
            super.func_75218_e();
        }
    }
}

