/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.wallets.items;

import de.cheaterpaul.wallets.items.ICoinContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CoinItem
extends Item
implements ICoinContainer {
    private static final Map<CoinValue, CoinItem> coinMap = new HashMap<CoinValue, CoinItem>(CoinValue.values().length, 1.0f);
    protected final CoinValue coinValue;

    public static CoinItem getCoin(CoinValue value) {
        return coinMap.get((Object)value);
    }

    public static Collection<CoinItem> getAllCoins() {
        return coinMap.values();
    }

    public CoinItem(CoinValue coinValue, Item.Properties properties) {
        super(properties);
        this.coinValue = coinValue;
        coinMap.put(coinValue, this);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag tooltipFlag) {
        int sum = ((ICoinContainer)stack.func_77973_b()).getCoins(stack);
        list.add((ITextComponent)new TranslationTextComponent("text.wallets.sum_amount", new Object[]{sum}).func_240699_a_(TextFormatting.DARK_GRAY));
    }

    @Override
    public int getCoins(ItemStack stack) {
        return stack.func_190916_E() * this.coinValue.getValue();
    }

    @Override
    public boolean removedOnUsage() {
        return true;
    }

    @Override
    public boolean containsCoins() {
        return false;
    }

    public static enum CoinValue {
        ONE(1),
        FIVE(5),
        TWENTY(20),
        FIFTY(50),
        ONE_HUNDRED(100),
        FIVE_HUNDRED(500);

        private final int value;

        private CoinValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

