/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.wallets.network;

import de.cheaterpaul.wallets.inventory.WalletContainer;
import de.cheaterpaul.wallets.items.CoinItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class InputEventPacket {
    public static final String INSERT_COIN = "ic";
    public static final String TAKE_COIN = "tc";
    public static final String TAKE_COINS = "tcs";
    public static final String CREATE_POUCH = "cp";
    public static final String UPDATE_WALLET = "uw";
    public static final String UPDATE_WALLET_TAKE = "uwt";
    private static final String SPLIT = "&";
    private String action;
    private String param;

    public InputEventPacket() {
        this("", "");
    }

    public InputEventPacket(String action) {
        this(action, "");
    }

    public InputEventPacket(String action, String param) {
        this.action = action;
        this.param = param;
    }

    static void encode(InputEventPacket msg, PacketBuffer buf) {
        buf.func_180714_a(msg.action + SPLIT + msg.param);
    }

    static InputEventPacket decode(PacketBuffer buf) {
        String[] s = buf.func_150789_c(50).split(SPLIT);
        InputEventPacket msg = new InputEventPacket();
        msg.action = s[0];
        msg.param = s.length > 1 ? s[1] : "";
        return msg;
    }

    public static void handle(InputEventPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Container menu = player.field_71070_bA;
        if (menu instanceof WalletContainer) {
            switch (msg.action) {
                case "ic": {
                    ((WalletContainer)menu).insertCoin();
                    break;
                }
                case "tc": {
                    ((WalletContainer)menu).takeCoin(CoinItem.CoinValue.valueOf(msg.param));
                    break;
                }
                case "tcs": {
                    ((WalletContainer)menu).takeCoins(Integer.parseInt(msg.param));
                    break;
                }
                case "cp": {
                    ((WalletContainer)menu).createPouch(Integer.parseInt(msg.param));
                }
            }
        }
    }
}

