/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.wallets.network;

import de.cheaterpaul.wallets.network.InputEventPacket;
import de.cheaterpaul.wallets.network.TakeCoinPacket;
import de.cheaterpaul.wallets.network.UpdateWalletPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class ModPacketDispatcher {
    protected final SimpleChannel dispatcher = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("wallets", "main")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private byte packetId = 0;
    private static final String PROTOCOL_VERSION = Integer.toString(1);

    protected int nextID() {
        byte by = this.packetId;
        this.packetId = (byte)(by + 1);
        return by;
    }

    public void registerPackets() {
        this.dispatcher.registerMessage(this.nextID(), InputEventPacket.class, InputEventPacket::encode, InputEventPacket::decode, InputEventPacket::handle);
        this.dispatcher.registerMessage(this.nextID(), TakeCoinPacket.class, TakeCoinPacket::encode, TakeCoinPacket::decode, TakeCoinPacket::handle);
        this.dispatcher.registerMessage(this.nextID(), UpdateWalletPacket.class, UpdateWalletPacket::encode, UpdateWalletPacket::decode, UpdateWalletPacket::handle);
    }

    public void sentToServer(InputEventPacket packet) {
        this.dispatcher.sendToServer((Object)packet);
    }

    public void sentToServer(TakeCoinPacket packet) {
        this.dispatcher.sendToServer((Object)packet);
    }

    public void sentToPlayer(UpdateWalletPacket packet, ServerPlayerEntity player) {
        this.dispatcher.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }
}

