/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import com.mojang.datafixers.DataFixUtils;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.cominixo.betterf3.ducks.ChunkBuilderAccess;
import me.cominixo.betterf3.ducks.ClientChunkManagerAccess;
import me.cominixo.betterf3.ducks.ClientChunkMapAccess;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class ChunksModule
extends BaseModule {
    public Color totalColor;
    public final Color defaultTotalColor = Color.func_240744_a_((TextFormatting)TextFormatting.GOLD);
    public final Color defaultEnabledColor = Color.func_240744_a_((TextFormatting)TextFormatting.GREEN);
    public final Color defaultDisabledColor = Color.func_240744_a_((TextFormatting)TextFormatting.RED);
    public Color enabledColor;
    public Color disabledColor;

    public ChunksModule() {
        this.defaultNameColor = Color.func_240743_a_((int)43775);
        this.defaultValueColor = Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.totalColor = this.defaultTotalColor;
        this.enabledColor = this.defaultEnabledColor;
        this.disabledColor = this.defaultDisabledColor;
        this.lines.add(new DebugLine("chunk_sections", "format.betterf3.total", true));
        this.lines.add(new DebugLine("chunk_culling"));
        this.lines.add(new DebugLine("pending_chunks"));
        this.lines.add(new DebugLine("pending_uploads"));
        this.lines.add(new DebugLine("available_buffers"));
        this.lines.add(new DebugLine("client_chunk_cache"));
        this.lines.add(new DebugLine("loaded_chunks"));
        this.lines.add(new DebugLine("loaded_chunks_server"));
        this.lines.add(new DebugLine("forceloaded_chunks"));
        this.lines.add(new DebugLine("spawn_chunks"));
        this.lines.add(new DebugLine("chunk_file"));
        ((DebugLine)this.lines.get((int)0)).inReducedDebug = true;
        ((DebugLine)this.lines.get((int)2)).inReducedDebug = true;
        ((DebugLine)this.lines.get((int)3)).inReducedDebug = true;
        ((DebugLine)this.lines.get((int)4)).inReducedDebug = true;
        ((DebugLine)this.lines.get((int)5)).inReducedDebug = true;
    }

    @Override
    public void update(Minecraft client) {
        World world;
        int totalChunks = client.field_71438_f.field_175008_n == null ? 0 : client.field_71438_f.field_175008_n.field_178164_f.length;
        int renderedChunks = client.field_71438_f.func_184382_g();
        ChunkRenderDispatcher chunkBuilder = client.field_71438_f.field_174995_M;
        ChunkBuilderAccess chunkBuilderDuck = (ChunkBuilderAccess)chunkBuilder;
        if (client.field_71441_e != null) {
            ClientChunkProvider clientChunkManager = client.field_71441_e.func_72863_F();
            ClientChunkManagerAccess clientChunkManagerMixin = (ClientChunkManagerAccess)clientChunkManager;
            ClientChunkMapAccess clientChunkMapMixin = (ClientChunkMapAccess)clientChunkManagerMixin.getChunks();
            ((DebugLine)this.lines.get(5)).value(clientChunkMapMixin.getChunks().length());
            ((DebugLine)this.lines.get(6)).value(clientChunkManager.func_217252_g());
        }
        LongSets.EmptySet forceLoadedChunks = (world = (World)DataFixUtils.orElse(Optional.ofNullable(client.func_71401_C()).flatMap(integratedServer -> Optional.ofNullable(integratedServer.func_71218_a(client.field_71441_e.func_234923_W_()))), (Object)client.field_71441_e)) instanceof ServerWorld ? ((ServerWorld)world).func_217469_z() : LongSets.EMPTY_SET;
        IntegratedServer integratedServer2 = client.func_71401_C();
        ServerWorld serverWorld = integratedServer2 != null ? integratedServer2.func_71218_a(client.field_71441_e.func_234923_W_()) : null;
        WorldEntitySpawner.EntityDensityManager info = null;
        if (serverWorld != null) {
            info = serverWorld.func_72863_F().func_241101_k_();
        }
        String chunkCulling = client.field_175612_E ? I18n.func_135052_a((String)"text.betterf3.line.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"text.betterf3.line.disabled", (Object[])new Object[0]);
        List<ITextComponent> chunkValues = Arrays.asList(Utils.styledText(I18n.func_135052_a((String)"text.betterf3.line.rendered", (Object[])new Object[0]), this.valueColor), Utils.styledText(I18n.func_135052_a((String)"text.betterf3.line.total", (Object[])new Object[0]), this.totalColor), Utils.styledText(Integer.toString(renderedChunks), this.valueColor), Utils.styledText(Integer.toString(totalChunks), this.totalColor));
        ((DebugLine)this.lines.get(0)).value(chunkValues);
        ((DebugLine)this.lines.get(1)).value(Utils.styledText(chunkCulling, client.field_175612_E ? this.enabledColor : this.disabledColor));
        if (chunkBuilderDuck != null) {
            ((DebugLine)this.lines.get(2)).value(chunkBuilderDuck.getQueuedTaskCount());
            ((DebugLine)this.lines.get(3)).value(chunkBuilderDuck.getUploadQueue().size());
            ((DebugLine)this.lines.get(4)).value(chunkBuilderDuck.getBufferCount());
        }
        if (serverWorld != null) {
            ((DebugLine)this.lines.get(7)).value(serverWorld.func_72863_F().func_73152_e());
        }
        ((DebugLine)this.lines.get(8)).value(forceLoadedChunks.size());
        if (info != null) {
            ((DebugLine)this.lines.get(9)).value(info.func_234988_a_());
        }
        BlockPos blockPos = Objects.requireNonNull(client.func_175606_aa()).func_233580_cy_();
        ChunkPos chunkPos = new ChunkPos(blockPos);
        String regionFile = String.valueOf(new Formatter().format("r.%d.%d.mca (%d, %d)", chunkPos.func_222241_h(), chunkPos.func_222242_i(), chunkPos.func_222240_j(), chunkPos.func_222238_k()));
        ((DebugLine)this.lines.get(10)).value(regionFile);
    }
}

