/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import java.util.Random;
import java.util.concurrent.CompletableFuture;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.overlay.DebugOverlayGui;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class LocationModule
extends BaseModule {
    @Nullable
    private CompletableFuture<Chunk> chunkFuture;

    public LocationModule() {
        this.defaultNameColor = Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN);
        this.defaultValueColor = Color.func_240744_a_((TextFormatting)TextFormatting.AQUA);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.lines.add(new DebugLine("dimension"));
        this.lines.add(new DebugLine("facing"));
        this.lines.add(new DebugLine("rotation"));
        this.lines.add(new DebugLine("light"));
        this.lines.add(new DebugLine("light_server"));
        this.lines.add(new DebugLine("highest_block"));
        this.lines.add(new DebugLine("highest_block_server"));
        this.lines.add(new DebugLine("biome"));
        this.lines.add(new DebugLine("local_difficulty"));
        this.lines.add(new DebugLine("day_ticks"));
        this.lines.add(new DebugLine("days_played"));
        this.lines.add(new DebugLine("slime_chunk"));
    }

    @Override
    public void update(Minecraft client) {
        Entity cameraEntity = client.func_175606_aa();
        IntegratedServer integratedServer = client.func_71401_C();
        String chunkLightString = "";
        String chunkLightServerString = "";
        String localDifficultyString = "";
        String slimeChunkString = "";
        StringBuilder highestBlock = new StringBuilder();
        StringBuilder highestBlockServer = new StringBuilder();
        if (client.field_71441_e != null) {
            assert (cameraEntity != null);
            BlockPos blockPos = cameraEntity.func_233580_cy_();
            ChunkPos chunkPos = new ChunkPos(blockPos);
            ((DebugLine)this.lines.get(7)).value(client.field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)client.field_71441_e.func_226691_t_(blockPos)));
            ClientWorld serverWorld = integratedServer != null ? integratedServer.func_71218_a(client.field_71441_e.func_234923_W_()) : client.field_71441_e;
            Chunk clientChunk = client.field_71441_e.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
            if (clientChunk.func_76621_g()) {
                chunkLightString = I18n.func_135052_a((String)"text.betterf3.line.waiting_chunk", (Object[])new Object[0]);
            } else if (serverWorld != null) {
                Chunk serverChunk;
                int totalLight = client.field_71441_e.func_72863_F().func_212863_j_().func_227470_b_(blockPos, 0);
                int skyLight = client.field_71441_e.func_226658_a_(LightType.SKY, blockPos);
                int blockLight = client.field_71441_e.func_226658_a_(LightType.BLOCK, blockPos);
                chunkLightString = I18n.func_135052_a((String)"format.betterf3.chunklight", (Object[])new Object[]{totalLight, skyLight, blockLight});
                WorldLightManager lightingProvider = serverWorld.func_72863_F().func_212863_j_();
                int skyLightServer = lightingProvider.func_215569_a(LightType.SKY).func_215611_b(blockPos);
                int blockLightServer = lightingProvider.func_215569_a(LightType.BLOCK).func_215611_b(blockPos);
                chunkLightServerString = I18n.func_135052_a((String)"format.betterf3.chunklight_server", (Object[])new Object[]{skyLightServer, blockLightServer});
                Heightmap.Type[] heightmapTypes = Heightmap.Type.values();
                if (serverWorld instanceof ServerWorld) {
                    if (this.chunkFuture == null) {
                        this.chunkFuture = ((ServerWorld)serverWorld).func_72863_F().func_217232_b(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222617_m, false).thenApply(either -> (Chunk)either.map(chunk -> (Chunk)chunk, chunk -> null));
                    }
                    if (this.chunkFuture == null) {
                        this.chunkFuture = CompletableFuture.completedFuture(clientChunk);
                    }
                    serverChunk = this.chunkFuture.getNow(null);
                } else {
                    serverChunk = clientChunk;
                }
                for (Heightmap.Type type : heightmapTypes) {
                    int blockY;
                    String typeString;
                    if (type.func_222681_b()) {
                        typeString = (String)DebugOverlayGui.field_212923_a.get(type);
                        blockY = clientChunk.func_201576_a(type, blockPos.func_177958_n(), blockPos.func_177952_p());
                        if (blockY > -1) {
                            highestBlock.append("  ").append(typeString).append(": ").append(blockY);
                        }
                    }
                    if (!type.func_222683_c() || !(serverWorld instanceof ServerWorld)) continue;
                    if (serverChunk == null) {
                        serverChunk = clientChunk;
                    }
                    typeString = (String)DebugOverlayGui.field_212923_a.get(type);
                    blockY = serverChunk.func_201576_a(type, blockPos.func_177958_n(), blockPos.func_177952_p());
                    if (blockY <= -1) continue;
                    highestBlockServer.append("  ").append(typeString).append(": ").append(blockY);
                }
                if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256) {
                    float moonSize = serverWorld.func_242413_ae();
                    long inhabitedTime = serverChunk == null ? clientChunk.func_177416_w() : serverChunk.func_177416_w();
                    DifficultyInstance localDifficulty = new DifficultyInstance(serverWorld.func_175659_aa(), serverWorld.func_72820_D(), inhabitedTime, moonSize);
                    localDifficultyString = String.format("%.2f  " + I18n.func_135052_a((String)"text.betterf3.line.clamped", (Object[])new Object[0]) + ": %.2f", Float.valueOf(localDifficulty.func_180168_b()), Float.valueOf(localDifficulty.func_180170_c()));
                }
                if (integratedServer != null) {
                    Random slimeChunk = SharedSeedRandom.func_205190_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (long)((ISeedReader)serverWorld).func_72905_C(), (long)987234911L);
                    slimeChunkString = String.format("%s", I18n.func_135052_a((String)(slimeChunk.nextInt(10) == 0 ? "text.betterf3.line.slime_chunk.true" : "text.betterf3.line.slime_chunk.false"), (Object[])new Object[0]));
                } else {
                    slimeChunkString = String.format("%s", I18n.func_135052_a((String)"text.betterf3.line.slime_chunk.unknown", (Object[])new Object[0]));
                }
            }
        }
        if (client.field_71441_e != null) {
            ((DebugLine)this.lines.get(0)).value(client.field_71441_e.func_234923_W_().func_240901_a_());
        }
        if (cameraEntity != null) {
            Direction facing = cameraEntity.func_174811_aO();
            String facingString = Utils.facingString(facing);
            ((DebugLine)this.lines.get(1)).value(String.format("%s (%s)", I18n.func_135052_a((String)("text.betterf3.line." + facing.toString().toLowerCase()), (Object[])new Object[0]), facingString));
            String yaw = String.format("%.1f", Float.valueOf(MathHelper.func_76142_g((float)cameraEntity.field_70177_z)));
            String pitch = String.format("%.1f", Float.valueOf(MathHelper.func_76142_g((float)cameraEntity.field_70125_A)));
            ((DebugLine)this.lines.get(2)).value(I18n.func_135052_a((String)"format.betterf3.rotation", (Object[])new Object[]{yaw, pitch}));
        }
        ((DebugLine)this.lines.get(3)).value(chunkLightString);
        ((DebugLine)this.lines.get(4)).value(chunkLightServerString);
        ((DebugLine)this.lines.get(5)).value(highestBlock.toString().trim());
        ((DebugLine)this.lines.get(6)).value(highestBlockServer.toString().trim());
        ((DebugLine)this.lines.get(8)).value(localDifficultyString);
        ((DebugLine)this.lines.get(9)).value(Long.valueOf(client.field_71441_e.func_72820_D() % 24000L).intValue());
        ((DebugLine)this.lines.get(10)).value(client.field_71441_e.func_72820_D() / 24000L);
        ((DebugLine)this.lines.get(11)).value(slimeChunkString.trim());
    }
}

