/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import java.util.Arrays;
import java.util.LinkedList;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ServerModule
extends BaseModule {
    public ServerModule() {
        this.defaultNameColor = Color.func_240744_a_((TextFormatting)TextFormatting.GRAY);
        this.defaultValueColor = Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.lines.add(new DebugLine("server_tick", "format.betterf3.server_tick", true));
        this.lines.add(new DebugLine("packets_sent"));
        this.lines.add(new DebugLine("packets_received"));
        for (DebugLine line : this.lines) {
            line.inReducedDebug = true;
        }
    }

    @Override
    public void update(Minecraft client) {
        IntegratedServer integratedServer = client.func_71401_C();
        String serverString = "";
        if (integratedServer != null) {
            serverString = I18n.func_135052_a((String)"text.betterf3.line.integrated_server", (Object[])new Object[0]);
        } else if (client.field_71439_g != null) {
            serverString = client.field_71439_g.func_142021_k();
        }
        if (client.func_147114_u() != null) {
            NetworkManager clientConnection = client.func_147114_u().func_147298_b();
            float packetsSent = clientConnection.func_211390_n();
            float packetsReceived = clientConnection.func_211393_m();
            ((DebugLine)this.lines.get(1)).value(Math.round(packetsSent));
            ((DebugLine)this.lines.get(2)).value(Math.round(packetsReceived));
        }
        String tickString = "";
        if (integratedServer != null) {
            tickString = Integer.toString(Math.round(integratedServer.func_211149_aT()));
        }
        LinkedList<IFormattableTextComponent> serverStringList = new LinkedList<IFormattableTextComponent>(Arrays.asList(Utils.styledText(serverString, this.nameColor), Utils.styledText(tickString, this.nameColor)));
        if (tickString.isEmpty()) {
            ((DebugLine)this.lines.get(0)).format("format.betterf3.no_format");
            serverStringList.remove(1);
        }
        ((DebugLine)this.lines.get(0)).value(serverStringList);
    }
}

