/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import com.mojang.blaze3d.platform.PlatformDescriptors;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.ArrayUtils;

public class SystemModule
extends BaseModule {
    public final boolean defaultMemoryColorToggle = true;
    public Boolean memoryColorToggle;
    public final String defaultTimeFormat = "HH:mm:ss";
    public String timeFormat;
    private static final List<GarbageCollectorMXBean> GARBAGE_COLLECTORS = ManagementFactory.getGarbageCollectorMXBeans();
    private long lastCalculated = 0L;
    private long allocatedBytes = -1L;
    private long collectionCount = -1L;
    private long allocationRate = 0L;

    public SystemModule() {
        this.defaultNameColor = Color.func_240744_a_((TextFormatting)TextFormatting.GOLD);
        this.defaultValueColor = Color.func_240744_a_((TextFormatting)TextFormatting.AQUA);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.memoryColorToggle = this.defaultMemoryColorToggle;
        this.timeFormat = this.defaultTimeFormat;
        this.lines.add(new DebugLine("time"));
        this.lines.add(new DebugLine("java_version"));
        this.lines.add(new DebugLine("memory_usage"));
        this.lines.add(new DebugLine("allocation_rate"));
        this.lines.add(new DebugLine("allocated_memory"));
        this.lines.add(new DebugLine("cpu"));
        this.lines.add(new DebugLine("display"));
        this.lines.add(new DebugLine("gpu"));
        this.lines.add(new DebugLine("opengl_version"));
        this.lines.add(new DebugLine("gpu_driver"));
        for (DebugLine line : this.lines) {
            line.inReducedDebug = true;
        }
    }

    @Override
    public void update(Minecraft client) {
        DateTimeFormatter timeFormatter;
        LocalDateTime currentTime = LocalDateTime.now();
        try {
            timeFormatter = DateTimeFormatter.ofPattern(this.timeFormat);
        }
        catch (IllegalArgumentException e) {
            this.timeFormat = this.defaultTimeFormat;
            timeFormatter = DateTimeFormatter.ofPattern(this.timeFormat);
        }
        String time = currentTime.format(timeFormatter);
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        MainWindow window = client.func_228018_at_();
        String javaVersion = String.format("%s %dbit", System.getProperty("java.version"), client.func_147111_S() ? 64 : 32);
        String memoryUsage = String.format("% 2d%% %03d/%03d MB", usedMemory * 100L / maxMemory, usedMemory / 1024L / 1024L, maxMemory / 1024L / 1024L);
        String allocationRate = String.format("% 2d MB/s", this.allocationRate(usedMemory) / 1024L / 1024L);
        String allocatedMemory = String.format("% 2d%% %03dMB", totalMemory * 100L / maxMemory, totalMemory / 1024L / 1024L);
        String displayInfo = String.format("%d x %d (%s)", window.func_198109_k(), window.func_198091_l(), PlatformDescriptors.func_227774_a_());
        Object[] versionSplit = PlatformDescriptors.func_227777_d_().split(" ");
        String openGlVersion = versionSplit[0];
        String gpuDriverVersion = String.join((CharSequence)" ", (CharSequence[])ArrayUtils.remove((Object[])versionSplit, (int)0));
        ((DebugLine)this.lines.get(0)).value(time);
        ((DebugLine)this.lines.get(1)).value(javaVersion);
        ((DebugLine)this.lines.get(2)).value(this.memoryColorToggle != false ? Utils.percentColor((int)(usedMemory * 100L / maxMemory)) + memoryUsage : memoryUsage);
        ((DebugLine)this.lines.get(3)).value(allocationRate);
        ((DebugLine)this.lines.get(4)).value(allocatedMemory);
        ((DebugLine)this.lines.get(5)).value(PlatformDescriptors.func_227775_b_());
        ((DebugLine)this.lines.get(6)).value(displayInfo);
        ((DebugLine)this.lines.get(7)).value(PlatformDescriptors.func_227776_c_());
        ((DebugLine)this.lines.get(8)).value(openGlVersion);
        ((DebugLine)this.lines.get(9)).value(gpuDriverVersion);
    }

    long allocationRate(long allocatedBytes) {
        long lastCalculated = System.currentTimeMillis();
        if (lastCalculated - this.lastCalculated >= 500L) {
            long collectionCount = SystemModule.collectionCount();
            if (this.lastCalculated != 0L && collectionCount == this.collectionCount) {
                double d = (double)TimeUnit.SECONDS.toMillis(1L) / (double)(lastCalculated - this.lastCalculated);
                long n = allocatedBytes - this.allocatedBytes;
                this.allocationRate = Math.round((double)n * d);
            }
            this.lastCalculated = lastCalculated;
            this.allocatedBytes = allocatedBytes;
            this.collectionCount = collectionCount;
        }
        return this.allocationRate;
    }

    private static long collectionCount() {
        long l = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : GARBAGE_COLLECTORS) {
            l += garbageCollectorMXBean.getCollectionCount();
        }
        return l;
    }
}

