/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.utils;

import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TranslationTextComponent;

public class DebugLine {
    private Object value;
    private String format;
    private final String id;
    public boolean active = true;
    public boolean enabled = true;
    public boolean isCustom = false;
    public boolean inReducedDebug = false;

    public DebugLine(String id) {
        this.id = id;
        this.format = "format.betterf3.default_format";
        this.value = "";
    }

    public DebugLine(String id, String formatString, boolean isCustom) {
        this.id = id;
        this.value = "";
        this.format = formatString;
        this.isCustom = isCustom;
    }

    public ITextComponent toText(Color nameColor, Color valueColor) {
        String name = this.name();
        IFormattableTextComponent nameStyled = Utils.styledText(name, nameColor);
        Object valueStyled = this.value instanceof ITextComponent ? (ITextComponent)this.value : Utils.styledText(this.value, valueColor);
        if (this.value.toString().equals("")) {
            this.active = false;
        }
        return new TranslationTextComponent(this.format, new Object[]{nameStyled, valueStyled});
    }

    public ITextComponent toTextCustom(Color nameColor) {
        String name = this.name();
        if (this.value instanceof List) {
            List listValue = (List)this.value;
            ArrayList<IFormattableTextComponent> values = new ArrayList<IFormattableTextComponent>();
            if (!name.equals("")) {
                values.add(Utils.styledText(name, nameColor));
            }
            values.addAll(listValue);
            return new TranslationTextComponent(this.format, values.toArray()).func_240700_a_(style -> style.func_240718_a_(nameColor));
        }
        return new TranslationTextComponent(this.format, new Object[]{name, this.value});
    }

    public void value(Object value) {
        this.active = true;
        this.value = value;
    }

    public void format(String format) {
        this.format = format;
    }

    public String name() {
        if (this.id.isEmpty()) {
            this.format = "%s%s";
            return "";
        }
        LanguageMap language = LanguageMap.func_74808_a();
        return language.func_230503_a_("text.betterf3.line." + this.id);
    }

    public String id() {
        return this.id;
    }
}

