/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay.tooltiprenderers;

import java.awt.Dimension;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.RenderContext;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.IconUI;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;

public class TooltipRendererArmor
implements ITooltipRenderer {
    @Override
    public Dimension getSize(CompoundNBT tag, ICommonAccessor accessor) {
        int maxHearts = Waila.CONFIG.get().getGeneral().getMaxHeartsPerLine();
        float armor = tag.func_74760_g("armor");
        if (armor == -1.0f) {
            maxHearts = 1;
            armor = 1;
        }
        int lineCount = (int)Math.ceil(armor / (float)maxHearts);
        return new Dimension(8 * maxHearts, 10 * lineCount);
    }

    @Override
    public void draw(CompoundNBT tag, ICommonAccessor accessor, int x, int y) {
        int maxHearts = Waila.CONFIG.get().getGeneral().getMaxHeartsPerLine();
        float armor = tag.func_74760_g("armor");
        if (armor == -1.0f) {
            maxHearts = 1;
            armor = 1;
        }
        int lineCount = (int)Math.ceil(armor / (float)maxHearts);
        int armorCount = lineCount * maxHearts;
        int xOffset = 0;
        for (int i = 1; i <= armorCount; ++i) {
            if (i <= MathHelper.func_76141_d((float)armor)) {
                DisplayUtil.renderIcon(RenderContext.matrixStack, x + xOffset, y, 8, 8, IconUI.ARMOR);
                xOffset += 8;
            }
            if ((float)i > armor && (float)i < armor + 1.0f) {
                DisplayUtil.renderIcon(RenderContext.matrixStack, x + xOffset, y, 8, 8, IconUI.HALF_ARMOR);
                xOffset += 8;
            }
            if ((float)i >= armor + 1.0f) {
                DisplayUtil.renderIcon(RenderContext.matrixStack, x + xOffset, y, 8, 8, IconUI.EMPTY_ARMOR);
                xOffset += 8;
            }
            if (i % maxHearts != 0) continue;
            y += 10;
            xOffset = 0;
        }
    }
}

