/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import snownee.jade.addon.vanilla.InventoryProvider;

public final class JadeCommonConfig {
    public static int inventorySneakShowAmount = 54;
    public static int inventoryNormalShowAmount = 0;
    public static int inventoryShowItemPreLine = 9;
    private static final Set<String> inventoryBlacklist = Sets.newHashSet();
    public static boolean bypassLockedContainer = false;
    private static boolean onlyShowVanilla = false;
    private static final Set<String> modBlacklist = Sets.newHashSet();
    private static ForgeConfigSpec.IntValue inventorySneakShowAmountVal;
    private static ForgeConfigSpec.IntValue inventoryNormalShowAmountVal;
    private static ForgeConfigSpec.IntValue inventoryShowItemPreLineVal;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> inventoryBlacklistVal;
    private static ForgeConfigSpec.BooleanValue bypassLockedContainerVal;
    private static ForgeConfigSpec.BooleanValue onlyShowVanillaVal;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> modBlacklistVal;
    static final ForgeConfigSpec spec;

    private JadeCommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("inventory");
        inventorySneakShowAmountVal = builder.defineInRange("sneakShowAmount", inventorySneakShowAmount, 0, 54);
        inventoryNormalShowAmountVal = builder.defineInRange("normalShowAmount", inventoryNormalShowAmount, 0, 54);
        inventoryShowItemPreLineVal = builder.defineInRange("showItemPreLine", inventoryShowItemPreLine, 1, 18);
        inventoryBlacklistVal = builder.defineList("blacklist", () -> Collections.singletonList("refinedstorage:disk_drive"), (Predicate)Predicates.alwaysTrue());
        bypassLockedContainerVal = builder.define("bypassLockedContainer", bypassLockedContainer);
        builder.pop();
        builder.push("customContainerName");
        onlyShowVanillaVal = builder.define("onlyShowVanilla", onlyShowVanilla);
        modBlacklistVal = builder.defineList("blacklist", () -> Collections.singletonList("thermal"), (Predicate)Predicates.alwaysTrue());
    }

    public static void refresh() {
        inventorySneakShowAmount = (Integer)inventorySneakShowAmountVal.get();
        inventoryNormalShowAmount = (Integer)inventoryNormalShowAmountVal.get();
        inventoryShowItemPreLine = (Integer)inventoryShowItemPreLineVal.get();
        bypassLockedContainer = (Boolean)bypassLockedContainerVal.get();
        inventoryBlacklist.clear();
        inventoryBlacklist.addAll(InventoryProvider.INVENTORY_IGNORE);
        inventoryBlacklist.addAll((Collection)inventoryBlacklistVal.get());
        onlyShowVanilla = (Boolean)onlyShowVanillaVal.get();
        modBlacklist.clear();
        modBlacklist.addAll((Collection)modBlacklistVal.get());
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfig.Reloading event) {
        ((CommentedFileConfig)event.getConfig().getConfigData()).load();
        JadeCommonConfig.refresh();
    }

    public static boolean shouldIgnoreTE(String id) {
        return inventoryBlacklist.contains(id);
    }

    public static boolean shouldShowCustomName(TileEntity t) {
        String modid = t.func_200662_C().getRegistryName().func_110624_b();
        if (onlyShowVanilla) {
            return modid.equals("minecraft");
        }
        return !modBlacklist.contains(modid);
    }

    static {
        spec = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(JadeCommonConfig::new).getRight();
    }
}

