/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OreDeposit
extends MineshaftPiece {
    private OreType oreType;
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 4;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 3;

    public OreDeposit(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.ORE_DEPOSIT, compoundTag);
        this.oreType = OreType.valueOf(compoundTag.func_74762_e("OreType"));
    }

    public OreDeposit(int chainLength, Random random, MutableBoundingBox blockBox, Direction direction, MineshaftVariantSettings settings) {
        super(BetterMineshaftStructurePieceType.ORE_DEPOSIT, chainLength, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
        tag.func_74768_a("OreType", this.oreType.value);
    }

    public static MutableBoundingBox determineBoxPosition(List<StructurePiece> list, Random random, int x, int y, int z, Direction direction) {
        MutableBoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)4, (Direction)direction);
        StructurePiece intersectingPiece = StructurePiece.func_74883_a(list, (MutableBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
        int r = random.nextInt(100);
        for (OreType oreType : OreType.values()) {
            if (r >= oreType.threshold) continue;
            this.oreType = oreType;
            break;
        }
        if (OreType.DIAMOND.threshold != 100) {
            BetterMineshafts.LOGGER.error("Your ore spawn chances don't add up to 100! Ores won't spawn as you intend!");
        }
        if (this.oreType == null) {
            this.oreType = OreType.COBBLE;
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos pos, BlockPos blockPos) {
        if (this.func_74860_a((IBlockReader)world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 3)) {
            return false;
        }
        BlockState COBBLE = Blocks.field_150347_e.func_176223_P();
        BlockState ORE_BLOCK = this.oreType.getBlock();
        this.chanceReplaceNonAir(world, box, random, 0.9f, 0, 0, 0, 4, 4, 3, COBBLE);
        this.chanceReplaceNonAir(world, box, random, 0.65f, 1, 1, 1, 3, 3, 2, ORE_BLOCK);
        this.chanceReplaceNonAir(world, box, random, 0.15f, 0, 0, 0, 4, 4, 3, ORE_BLOCK);
        return true;
    }

    public static enum OreType {
        COBBLE(0, Blocks.field_150347_e.func_176223_P(), (Integer)Configuration.ores.cobble.get()),
        COAL(1, Blocks.field_150365_q.func_176223_P(), (Integer)Configuration.ores.coal.get() + OreType.COBBLE.threshold),
        IRON(2, Blocks.field_150366_p.func_176223_P(), (Integer)Configuration.ores.iron.get() + OreType.COAL.threshold),
        REDSTONE(3, Blocks.field_150450_ax.func_176223_P(), (Integer)Configuration.ores.redstone.get() + OreType.IRON.threshold),
        GOLD(4, Blocks.field_150352_o.func_176223_P(), (Integer)Configuration.ores.gold.get() + OreType.REDSTONE.threshold),
        LAPIS(5, Blocks.field_150369_x.func_176223_P(), (Integer)Configuration.ores.lapis.get() + OreType.GOLD.threshold),
        EMERALD(6, Blocks.field_150412_bA.func_176223_P(), (Integer)Configuration.ores.emerald.get() + OreType.LAPIS.threshold),
        DIAMOND(7, Blocks.field_150482_ag.func_176223_P(), (Integer)Configuration.ores.diamond.get() + OreType.EMERALD.threshold);

        private final int value;
        private final BlockState block;
        private int threshold;

        private OreType(int value, BlockState block, int threshold) {
            this.value = value;
            this.block = block;
            this.threshold = threshold;
        }

        public static OreType valueOf(int value) {
            return Arrays.stream(OreType.values()).filter(oreType -> oreType.value == value).findFirst().get();
        }

        public BlockState getBlock() {
            return this.block;
        }
    }
}

