/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ZombieVillagerRoom
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 7;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 7;
    private static final int LOCAL_X_END = 6;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 6;

    public ZombieVillagerRoom(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.ZOMBIE_VILLAGER_ROOM, compoundTag);
    }

    public ZombieVillagerRoom(int chainLength, Random random, MutableBoundingBox blockBox, Direction direction, MineshaftVariantSettings settings) {
        super(BetterMineshaftStructurePieceType.ZOMBIE_VILLAGER_ROOM, chainLength, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
    }

    public static MutableBoundingBox determineBoxPosition(List<StructurePiece> list, Random random, int x, int y, int z, Direction direction) {
        MutableBoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)7, (int)5, (int)7, (Direction)direction);
        StructurePiece intersectingPiece = StructurePiece.func_74883_a(list, (MutableBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos pos, BlockPos blockPos) {
        if (this.func_74860_a((IBlockReader)world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 6, 6)) {
            return false;
        }
        this.fill(world, box, 1, 0, 0, 5, 2, 0, Blocks.field_150348_b.func_176223_P());
        this.fill(world, box, 0, 0, 1, 0, 2, 5, Blocks.field_150348_b.func_176223_P());
        this.fill(world, box, 6, 0, 1, 6, 2, 5, Blocks.field_150348_b.func_176223_P());
        this.fill(world, box, 1, 0, 6, 5, 2, 6, Blocks.field_150348_b.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.4f, 1, 0, 0, 5, 2, 0, Blocks.field_150347_e.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.4f, 0, 0, 1, 0, 2, 5, Blocks.field_150347_e.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.4f, 6, 0, 1, 6, 2, 5, Blocks.field_150347_e.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.4f, 1, 0, 6, 5, 2, 6, Blocks.field_150347_e.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 1, 0, 0, 5, 2, 0, Blocks.field_196696_di.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 0, 0, 1, 0, 2, 5, Blocks.field_196696_di.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 6, 0, 1, 6, 2, 5, Blocks.field_196696_di.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 1, 0, 6, 5, 2, 6, Blocks.field_196696_di.func_176223_P());
        this.fill(world, box, 2, 3, 0, 4, 3, 0, Blocks.field_150333_U.func_176223_P());
        this.fill(world, box, 0, 3, 2, 0, 3, 4, Blocks.field_150333_U.func_176223_P());
        this.fill(world, box, 6, 3, 2, 6, 3, 4, Blocks.field_150333_U.func_176223_P());
        this.fill(world, box, 2, 3, 6, 4, 3, 6, Blocks.field_150333_U.func_176223_P());
        this.chanceFill(world, box, random, 0.5f, 2, 3, 0, 4, 3, 0, Blocks.field_196646_bz.func_176223_P());
        this.chanceFill(world, box, random, 0.5f, 0, 3, 2, 0, 3, 4, Blocks.field_196646_bz.func_176223_P());
        this.chanceFill(world, box, random, 0.5f, 6, 3, 2, 6, 3, 4, Blocks.field_196646_bz.func_176223_P());
        this.chanceFill(world, box, random, 0.5f, 2, 3, 6, 4, 3, 6, Blocks.field_196646_bz.func_176223_P());
        this.fill(world, box, 2, 3, 1, 4, 3, 1, (BlockState)((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP));
        this.fill(world, box, 1, 3, 2, 1, 3, 4, (BlockState)((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.WEST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP));
        this.fill(world, box, 2, 3, 5, 4, 3, 5, (BlockState)((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.NORTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP));
        this.fill(world, box, 5, 3, 2, 5, 3, 4, (BlockState)((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP));
        this.func_175811_a(world, (BlockState)((BlockState)((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_RIGHT)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 1, 3, 1, box);
        this.func_175811_a(world, (BlockState)((BlockState)((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_LEFT)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 1, 3, 5, box);
        this.func_175811_a(world, (BlockState)((BlockState)((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_LEFT)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 5, 3, 1, box);
        this.func_175811_a(world, (BlockState)((BlockState)((BlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_RIGHT)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 5, 3, 5, box);
        this.fill(world, box, 2, 4, 2, 4, 4, 4, Blocks.field_150333_U.func_176223_P());
        this.chanceFill(world, box, random, 0.5f, 2, 4, 2, 4, 4, 4, Blocks.field_196646_bz.func_176223_P());
        this.func_175811_a(world, field_202556_l, 3, 4, 3, box);
        this.func_175811_a(world, (BlockState)Blocks.field_150333_U.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP), 3, 4, 3, box);
        this.fill(world, box, 1, 0, 1, 5, 0, 5, Blocks.field_150348_b.func_176223_P());
        this.chanceFill(world, box, random, 0.4f, 1, 0, 1, 5, 0, 5, Blocks.field_150347_e.func_176223_P());
        this.chanceFill(world, box, random, 0.1f, 1, 0, 1, 5, 0, 5, Blocks.field_196696_di.func_176223_P());
        this.fill(world, box, 1, 1, 1, 5, 2, 5, field_202556_l);
        this.fill(world, box, 2, 3, 2, 4, 3, 4, field_202556_l);
        this.fill(world, box, 3, 1, 0, 3, 2, 0, field_202556_l);
        this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150454_av.func_176223_P().func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.NORTH)).func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER), 3, 1, 0, box);
        this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150454_av.func_176223_P().func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.NORTH)).func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), 3, 2, 0, box);
        this.fill(world, box, 6, 2, 2, 6, 2, 4, Blocks.field_150411_aY.func_176223_P());
        this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196551_aB.func_176223_P().func_206870_a((Property)BedBlock.field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.FOOT), 1, 1, 4, box);
        this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196551_aB.func_176223_P().func_206870_a((Property)BedBlock.field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD), 1, 1, 5, box);
        this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196551_aB.func_176223_P().func_206870_a((Property)BedBlock.field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.FOOT), 5, 1, 4, box);
        this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_196551_aB.func_176223_P().func_206870_a((Property)BedBlock.field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD), 5, 1, 5, box);
        BlockPos spawnerPos = new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(0), this.func_74873_b(3, 3));
        world.func_180501_a(spawnerPos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntity blockEntity = world.func_175625_s(spawnerPos);
        if (blockEntity instanceof MobSpawnerTileEntity) {
            ((MobSpawnerTileEntity)blockEntity).func_145881_a().func_200876_a(EntityType.field_200727_aF);
        }
        this.func_175811_a(world, Blocks.field_150463_bK.func_176223_P(), 1, 1, 1, box);
        this.func_175811_a(world, Blocks.field_150429_aA.func_176223_P(), 1, 2, 1, box);
        this.addBarrel(world, box, random, 5, 1, 1, LootTables.field_186424_f);
        this.func_175811_a(world, Blocks.field_150430_aB.func_176223_P(), 2, 2, 1, box);
        this.func_175811_a(world, Blocks.field_150467_bQ.func_176223_P(), 5, 1, 2, box);
        if (random.nextFloat() < 0.33f) {
            this.func_175811_a(world, Blocks.field_222429_lR.func_176223_P(), 2, 1, 5, box);
        } else if (random.nextFloat() < 0.67f) {
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 2, 1, 5, box);
        } else {
            this.func_175811_a(world, Blocks.field_222424_lM.func_176223_P(), 2, 1, 5, box);
        }
        this.chanceFill(world, box, random, 0.3f, 2, 3, 2, 4, 3, 4, Blocks.field_196553_aF.func_176223_P());
        return true;
    }
}

