/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungsbridges.YungsBridges;
import com.yungnickyoung.minecraft.yungsbridges.world.processor.ITemplateFeatureProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public abstract class AbstractTemplateFeature<C extends IFeatureConfig>
extends Feature<C> {
    protected List<ITemplateFeatureProcessor> processors = this.useProcessors();

    public AbstractTemplateFeature(Codec<C> codec) {
        super(codec);
    }

    protected Template createTemplate(ResourceLocation id, ISeedReader world, Random rand, BlockPos pos) {
        return this.createTemplateWithPlacement(id, world, rand, pos, new PlacementSettings());
    }

    protected Template createTemplateWithPlacement(ResourceLocation id, ISeedReader world, Random rand, BlockPos pos, PlacementSettings placement) {
        Template template = world.func_201672_e().func_184163_y().func_200219_b(id);
        if (template == null) {
            YungsBridges.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return null;
        }
        template.func_237144_a_((IServerWorld)world, pos, placement, rand);
        this.processors.forEach(processor -> processor.processTemplate(template, world, rand, pos, placement));
        return template;
    }

    protected List<ITemplateFeatureProcessor> useProcessors() {
        return new ArrayList<ITemplateFeatureProcessor>();
    }
}

