/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.processor;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public interface ITemplateFeatureProcessor {
    public static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    public static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();

    public void processTemplate(Template var1, ISeedReader var2, Random var3, BlockPos var4, PlacementSettings var5);

    default public void generatePillarDown(ISeedReader world, BlockPos pos, Supplier<BlockState> replacementBlockSupplier, Supplier<BlockState> legBlockSupplier) {
        world.func_180501_a(pos, replacementBlockSupplier.get(), 2);
        BlockPos.Mutable mutable = pos.func_177977_b().func_239590_i_();
        BlockState currBlock = world.func_180495_p((BlockPos)mutable);
        while (mutable.func_177956_o() > 0 && (currBlock.func_185904_a() == Material.field_151579_a || currBlock.func_185904_a() == Material.field_151586_h || currBlock.func_185904_a() == Material.field_151587_i)) {
            world.func_180501_a((BlockPos)mutable, legBlockSupplier.get(), 2);
            mutable.func_189536_c(Direction.DOWN);
            currBlock = world.func_180495_p((BlockPos)mutable);
        }
    }

    default public BlockState getStairsBlockWithState(BlockState input, BlockState source) {
        if (input.func_177230_c() instanceof StairsBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)input.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)(source.func_235901_b_((Property)StairsBlock.field_176309_a) ? (Direction)source.func_177229_b((Property)StairsBlock.field_176309_a) : Direction.NORTH))).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)(source.func_235901_b_((Property)StairsBlock.field_176308_b) ? (Half)source.func_177229_b((Property)StairsBlock.field_176308_b) : Half.BOTTOM))).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)(source.func_235901_b_((Property)StairsBlock.field_176310_M) ? (StairsShape)source.func_177229_b((Property)StairsBlock.field_176310_M) : StairsShape.STRAIGHT))).func_206870_a((Property)StairsBlock.field_204513_t, (Comparable)(source.func_235901_b_((Property)StairsBlock.field_204513_t) ? (Boolean)source.func_177229_b((Property)StairsBlock.field_204513_t) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getSlabBlockWithState(BlockState input, BlockState source) {
        if (input.func_177230_c() instanceof SlabBlock) {
            return (BlockState)((BlockState)input.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)(source.func_235901_b_((Property)SlabBlock.field_196505_a) ? (SlabType)source.func_177229_b((Property)SlabBlock.field_196505_a) : SlabType.BOTTOM))).func_206870_a((Property)SlabBlock.field_204512_b, (Comparable)(source.func_235901_b_((Property)SlabBlock.field_204512_b) ? (Boolean)source.func_177229_b((Property)SlabBlock.field_204512_b) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getWallBlockWithState(BlockState input, BlockState source) {
        if (input.func_177230_c() instanceof WallBlock && source.func_177230_c() instanceof WallBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)input.func_206870_a((Property)WallBlock.field_235613_c_, (Comparable)(source.func_235901_b_((Property)WallBlock.field_235613_c_) ? (WallHeight)source.func_177229_b((Property)WallBlock.field_235613_c_) : WallHeight.NONE))).func_206870_a((Property)WallBlock.field_235612_b_, (Comparable)(source.func_235901_b_((Property)WallBlock.field_235612_b_) ? (WallHeight)source.func_177229_b((Property)WallBlock.field_235612_b_) : WallHeight.NONE))).func_206870_a((Property)WallBlock.field_235614_d_, (Comparable)(source.func_235901_b_((Property)WallBlock.field_235614_d_) ? (WallHeight)source.func_177229_b((Property)WallBlock.field_235614_d_) : WallHeight.NONE))).func_206870_a((Property)WallBlock.field_235615_e_, (Comparable)(source.func_235901_b_((Property)WallBlock.field_235615_e_) ? (WallHeight)source.func_177229_b((Property)WallBlock.field_235615_e_) : WallHeight.NONE))).func_206870_a((Property)WallBlock.field_176256_a, (Comparable)(source.func_235901_b_((Property)WallBlock.field_176256_a) ? (Boolean)source.func_177229_b((Property)WallBlock.field_176256_a) : Boolean.valueOf(true)))).func_206870_a((Property)WallBlock.field_235616_f_, (Comparable)(source.func_235901_b_((Property)WallBlock.field_235616_f_) ? (Boolean)source.func_177229_b((Property)WallBlock.field_235616_f_) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getFenceBlockWithState(BlockState input, BlockState source) {
        if (input.func_177230_c() instanceof FenceBlock) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)input.func_206870_a((Property)FenceBlock.field_196409_a, (Comparable)(source.func_235901_b_((Property)FenceBlock.field_196409_a) ? (Boolean)source.func_177229_b((Property)FenceBlock.field_196409_a) : Boolean.valueOf(false)))).func_206870_a((Property)FenceBlock.field_196411_b, (Comparable)(source.func_235901_b_((Property)FenceBlock.field_196411_b) ? (Boolean)source.func_177229_b((Property)FenceBlock.field_196411_b) : Boolean.valueOf(false)))).func_206870_a((Property)FenceBlock.field_196413_c, (Comparable)(source.func_235901_b_((Property)FenceBlock.field_196413_c) ? (Boolean)source.func_177229_b((Property)FenceBlock.field_196413_c) : Boolean.valueOf(false)))).func_206870_a((Property)FenceBlock.field_196414_y, (Comparable)(source.func_235901_b_((Property)FenceBlock.field_196414_y) ? (Boolean)source.func_177229_b((Property)FenceBlock.field_196414_y) : Boolean.valueOf(false)))).func_206870_a((Property)FenceBlock.field_204514_u, (Comparable)(source.func_235901_b_((Property)FenceBlock.field_204514_u) ? (Boolean)source.func_177229_b((Property)FenceBlock.field_204514_u) : Boolean.valueOf(false)));
        }
        return input;
    }

    default public BlockState getLogBlockWithState(BlockState input, BlockState source) {
        if (input.func_177230_c() instanceof RotatedPillarBlock) {
            return (BlockState)input.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)(source.func_235901_b_((Property)RotatedPillarBlock.field_176298_M) ? (Direction.Axis)source.func_177229_b((Property)RotatedPillarBlock.field_176298_M) : Direction.Axis.Y));
        }
        return input;
    }

    default public BlockState getLanternBlockWithState(BlockState input, BlockState source) {
        if (input.func_177230_c() instanceof LanternBlock) {
            return (BlockState)((BlockState)input.func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)(source.func_235901_b_((Property)LanternBlock.field_220278_a) ? (Boolean)source.func_177229_b((Property)LanternBlock.field_220278_a) : Boolean.valueOf(true)))).func_206870_a((Property)LanternBlock.field_242675_b, (Comparable)(source.func_235901_b_((Property)LanternBlock.field_242675_b) ? (Boolean)source.func_177229_b((Property)LanternBlock.field_242675_b) : Boolean.valueOf(true)));
        }
        return input;
    }

    default public BlockState getFenceBiomeVariant(Biome biome) {
        switch (biome.func_201856_r()) {
            case MESA: {
                return Blocks.field_180406_aS.func_176223_P();
            }
            case TAIGA: {
                return Blocks.field_180408_aP.func_176223_P();
            }
            case JUNGLE: {
                return Blocks.field_180403_aR.func_176223_P();
            }
            case SAVANNA: {
                return Blocks.field_180405_aT.func_176223_P();
            }
        }
        return Blocks.field_180407_aO.func_176223_P();
    }

    default public BlockState getLogBiomeVariant(Biome biome) {
        switch (biome.func_201856_r()) {
            case MESA: {
                return Blocks.field_196623_P.func_176223_P();
            }
            case TAIGA: {
                return Blocks.field_196618_L.func_176223_P();
            }
            case JUNGLE: {
                return Blocks.field_196620_N.func_176223_P();
            }
            case SAVANNA: {
                return Blocks.field_196621_O.func_176223_P();
            }
        }
        return Blocks.field_196617_K.func_176223_P();
    }

    default public BlockState getPlanksBiomeVariant(Biome biome) {
        switch (biome.func_201856_r()) {
            case MESA: {
                return Blocks.field_196672_s.func_176223_P();
            }
            case TAIGA: {
                return Blocks.field_196664_o.func_176223_P();
            }
            case JUNGLE: {
                return Blocks.field_196668_q.func_176223_P();
            }
            case SAVANNA: {
                return Blocks.field_196670_r.func_176223_P();
            }
        }
        return Blocks.field_196662_n.func_176223_P();
    }

    default public BlockState getSlabBiomeVariant(Biome biome) {
        switch (biome.func_201856_r()) {
            case MESA: {
                return Blocks.field_196635_bv.func_176223_P();
            }
            case TAIGA: {
                return Blocks.field_196624_br.func_176223_P();
            }
            case JUNGLE: {
                return Blocks.field_196630_bt.func_176223_P();
            }
            case SAVANNA: {
                return Blocks.field_196632_bu.func_176223_P();
            }
        }
        return Blocks.field_196622_bq.func_176223_P();
    }

    default public BlockState getStairsBiomeVariant(Biome biome) {
        switch (biome.func_201856_r()) {
            case MESA: {
                return Blocks.field_150401_cl.func_176223_P();
            }
            case TAIGA: {
                return Blocks.field_150485_bF.func_176223_P();
            }
            case JUNGLE: {
                return Blocks.field_150481_bH.func_176223_P();
            }
            case SAVANNA: {
                return Blocks.field_150400_ck.func_176223_P();
            }
        }
        return Blocks.field_150476_ad.func_176223_P();
    }
}

