/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.bookmarks;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientManager;
import net.minecraft.item.ItemStack;

public class BookmarkList
implements IIngredientGridSource {
    private final List<Object> list = new LinkedList<Object>();
    private final List<IIngredientListElement<?>> ingredientListElements = new LinkedList();
    private final IngredientManager ingredientManager;
    private final BookmarkConfig bookmarkConfig;
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();

    public BookmarkList(IngredientManager ingredientManager, BookmarkConfig bookmarkConfig) {
        this.ingredientManager = ingredientManager;
        this.bookmarkConfig = bookmarkConfig;
    }

    public <T> boolean add(T ingredient) {
        if (this.contains(ingredient)) {
            return false;
        }
        this.addToLists(ingredient, true);
        this.notifyListenersOfChange();
        this.bookmarkConfig.saveBookmarks(this.ingredientManager, this.ingredientListElements);
        return true;
    }

    private <T> boolean contains(T ingredient) {
        return this.indexOf(ingredient) >= 0;
    }

    private <T> int indexOf(T ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        ingredient = ingredientHelper.normalizeIngredient(ingredient);
        String uniqueId = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
        for (int i = 0; i < this.list.size(); ++i) {
            Object existing = this.list.get(i);
            if (!BookmarkList.equal(ingredientHelper, ingredient, uniqueId, existing)) continue;
            return i;
        }
        return -1;
    }

    private static <T> boolean equal(IIngredientHelper<T> ingredientHelper, T a, String uidA, Object b) {
        if (a == b) {
            return true;
        }
        if (!a.getClass().isInstance(b)) {
            return false;
        }
        if (a instanceof ItemStack) {
            return ItemStack.func_77989_b((ItemStack)((ItemStack)a), (ItemStack)((ItemStack)b));
        }
        Object castB = b;
        String uidB = ingredientHelper.getUniqueId(castB, UidContext.Ingredient);
        return uidA.equals(uidB);
    }

    public <T> boolean remove(T ingredient) {
        int index = this.indexOf(ingredient);
        if (index < 0) {
            return false;
        }
        this.list.remove(index);
        this.ingredientListElements.remove(index);
        this.notifyListenersOfChange();
        this.bookmarkConfig.saveBookmarks(this.ingredientManager, this.ingredientListElements);
        return true;
    }

    public <T> void addToLists(T ingredient, boolean addToFront) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        ingredient = ingredientHelper.normalizeIngredient(ingredient);
        IIngredientListElement<T> element = IngredientListElementFactory.createUnorderedElement(ingredient);
        if (addToFront) {
            this.list.add(0, ingredient);
            this.ingredientListElements.add(0, element);
        } else {
            this.list.add(ingredient);
            this.ingredientListElements.add(element);
        }
    }

    @Override
    public List<IIngredientListElement<?>> getIngredientList(String filterText) {
        return this.ingredientListElements;
    }

    public boolean isEmpty() {
        return this.ingredientListElements.isEmpty();
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }
}

