/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.events.EditModeToggleEvent;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientListElementInfo;
import mezz.jei.search.ElementPrefixParser;
import mezz.jei.search.ElementSearch;
import mezz.jei.search.ElementSearchLowMem;
import mezz.jei.search.IElementSearch;
import mezz.jei.util.LoggedTimer;
import mezz.jei.util.Translator;
import net.minecraft.util.NonNullList;
import org.apache.logging.log4j.LogManager;

public class IngredientFilter
implements IIngredientGridSource {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    private final IngredientBlacklistInternal blacklist;
    private final IWorldConfig worldConfig;
    private final IEditModeConfig editModeConfig;
    private final IIngredientManager ingredientManager;
    private final IIngredientSorter sorter;
    private final boolean debugMode;
    private final IElementSearch elementSearch;
    private final ElementPrefixParser elementPrefixParser;
    private final Set<String> modNamesForSorting = new HashSet<String>();
    @Nullable
    private String filterCached;
    private List<IIngredientListElement<?>> ingredientListCached = Collections.emptyList();
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();

    public IngredientFilter(IngredientBlacklistInternal blacklist, IWorldConfig worldConfig, IClientConfig clientConfig, IIngredientFilterConfig config, IEditModeConfig editModeConfig, IIngredientManager ingredientManager, IIngredientSorter sorter, NonNullList<IIngredientListElement<?>> ingredients, IModIdHelper modIdHelper) {
        this.blacklist = blacklist;
        this.worldConfig = worldConfig;
        this.editModeConfig = editModeConfig;
        this.ingredientManager = ingredientManager;
        this.sorter = sorter;
        this.elementPrefixParser = new ElementPrefixParser(ingredientManager, config);
        this.elementSearch = clientConfig.isLowMemorySlowSearchEnabled() ? new ElementSearchLowMem() : new ElementSearch(this.elementPrefixParser);
        this.debugMode = clientConfig.isDebugModeEnabled();
        EventBusHelper.registerWeakListener(this, EditModeToggleEvent.class, (ingredientFilter, editModeToggleEvent) -> ingredientFilter.updateHidden());
        EventBusHelper.registerWeakListener(this, PlayerJoinedWorldEvent.class, (ingredientFilter, playerJoinedWorldEvent) -> ingredientFilter.updateHidden());
        List ingredientInfo = ingredients.stream().map(i -> IngredientListElementInfo.create(i, ingredientManager, modIdHelper)).collect(Collectors.toList());
        for (IIngredientListElementInfo element : ingredientInfo) {
            this.addIngredient(element);
        }
    }

    public <V> void addIngredient(IIngredientListElementInfo<V> info) {
        IIngredientListElement<V> element = info.getElement();
        this.updateHiddenState(element);
        this.elementSearch.add(info);
        String modNameForSorting = info.getModNameForSorting();
        this.modNamesForSorting.add(modNameForSorting);
        this.invalidateCache();
    }

    public void invalidateCache() {
        this.filterCached = null;
        this.sorter.invalidateCache();
    }

    public <V> List<IIngredientListElementInfo<V>> findMatchingElements(IIngredientHelper<V> ingredientHelper, V ingredient) {
        String ingredientUid = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
        String displayName = ingredientHelper.getDisplayName(ingredient);
        Class<?> ingredientClass = ingredient.getClass();
        ArrayList<IIngredientListElementInfo<V>> matchingElements = new ArrayList<IIngredientListElementInfo<V>>();
        ElementPrefixParser.TokenInfo tokenInfo = new ElementPrefixParser.TokenInfo(Translator.toLowercaseWithLocale(displayName), ElementPrefixParser.NO_PREFIX);
        Set<IIngredientListElementInfo<?>> searchResults = this.elementSearch.getSearchResults(tokenInfo);
        if (searchResults.isEmpty()) {
            return matchingElements;
        }
        for (IIngredientListElementInfo<?> matchingElementInfo : searchResults) {
            Object castMatchingIngredient;
            String matchingUid;
            Object matchingIngredient = matchingElementInfo.getElement().getIngredient();
            if (!ingredientClass.isInstance(matchingIngredient) || !ingredientUid.equals(matchingUid = ingredientHelper.getUniqueId(castMatchingIngredient = ingredientClass.cast(matchingIngredient), UidContext.Ingredient))) continue;
            IIngredientListElementInfo<?> matchingElementInfoCast = matchingElementInfo;
            matchingElements.add(matchingElementInfoCast);
        }
        return matchingElements;
    }

    public void modesChanged() {
        this.filterCached = null;
    }

    public void updateHidden() {
        boolean changed = false;
        for (IIngredientListElementInfo<?> info : this.elementSearch.getAllIngredients()) {
            IIngredientListElement<?> element = info.getElement();
            changed |= this.updateHiddenState(element);
        }
        if (changed) {
            this.filterCached = null;
            this.notifyListenersOfChange();
        }
    }

    @Override
    public List<IIngredientListElement<?>> getIngredientList(String filterText) {
        if (!(filterText = filterText.toLowerCase()).equals(this.filterCached)) {
            List<IIngredientListElementInfo<?>> ingredientList = this.getIngredientListUncached(filterText);
            LoggedTimer filterTimer = new LoggedTimer();
            if (this.debugMode) {
                filterTimer.start("Filtering and Sorting: " + filterText);
            }
            this.ingredientListCached = ingredientList.stream().sorted(this.sorter.getComparator(this, this.ingredientManager)).map(IIngredientListElementInfo::getElement).collect(Collectors.toList());
            if (this.debugMode) {
                filterTimer.stop();
                LogManager.getLogger().info("Filter has " + this.ingredientListCached.size() + " of " + ingredientList.size());
            }
            this.filterCached = filterText;
        }
        return this.ingredientListCached;
    }

    public List<IIngredientListElementInfo<?>> getIngredientListPreSort(Comparator<IIngredientListElementInfo<?>> directComparator) {
        Collection<IIngredientListElementInfo<?>> ingredientList = this.elementSearch.getAllIngredients();
        LoggedTimer filterTimer = new LoggedTimer();
        if (this.debugMode) {
            filterTimer.start("Pre-Sorting.");
        }
        List<IIngredientListElementInfo<?>> fullSortedList = ingredientList.stream().sorted(directComparator).collect(Collectors.toList());
        if (this.debugMode) {
            filterTimer.stop();
            LogManager.getLogger().info("Sort has " + ingredientList.size());
        }
        return fullSortedList;
    }

    public Set<String> getModNamesForSorting() {
        return Collections.unmodifiableSet(this.modNamesForSorting);
    }

    public ImmutableList<Object> getFilteredIngredients(String filterText) {
        List<IIngredientListElement<?>> elements = this.getIngredientList(filterText);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IIngredientListElement<?> element : elements) {
            Object ingredient = element.getIngredient();
            builder.add(ingredient);
        }
        return builder.build();
    }

    private List<IIngredientListElementInfo<?>> getIngredientListUncached(String filterText) {
        String[] filters = filterText.split("\\|");
        List searchTokens = Arrays.stream(filters).map(this::parseSearchTokens).filter(s -> !((SearchTokens)s).toSearch.isEmpty()).collect(Collectors.toList());
        Stream<IIngredientListElementInfo<Object>> elementInfoStream = searchTokens.isEmpty() ? this.elementSearch.getAllIngredients().parallelStream() : searchTokens.stream().map(this::getSearchResults).flatMap(Collection::stream).distinct();
        return elementInfoStream.filter(info -> info.getElement().isVisible()).sorted(this.sorter.getComparator(this, this.ingredientManager)).collect(Collectors.toList());
    }

    private SearchTokens parseSearchTokens(String filterText) {
        SearchTokens searchTokens = new SearchTokens(new ArrayList(), new ArrayList());
        if (filterText.isEmpty()) {
            return searchTokens;
        }
        Matcher filterMatcher = FILTER_SPLIT_PATTERN.matcher(filterText);
        while (filterMatcher.find()) {
            String string = filterMatcher.group(1);
            boolean remove = string.startsWith("-");
            if (remove) {
                string = string.substring(1);
            }
            if ((string = QUOTE_PATTERN.matcher(string).replaceAll("")).isEmpty()) continue;
            this.elementPrefixParser.parseToken(string).ifPresent(result -> {
                if (remove) {
                    searchTokens.toRemove.add(result);
                } else {
                    searchTokens.toSearch.add(result);
                }
            });
        }
        return searchTokens;
    }

    public <V> Stream<IIngredientListElementInfo<V>> searchForMatchingElement(V ingredient, IIngredientHelper<V> ingredientHelper, Function<V, String> uidFunction) {
        String ingredientUid = uidFunction.apply(ingredient);
        String displayName = ingredientHelper.getDisplayName(ingredient);
        String lowercaseDisplayName = Translator.toLowercaseWithLocale(displayName);
        ElementPrefixParser.TokenInfo tokenInfo = new ElementPrefixParser.TokenInfo(lowercaseDisplayName, ElementPrefixParser.NO_PREFIX);
        Class<?> ingredientClass = ingredient.getClass();
        return this.elementSearch.getSearchResults(tokenInfo).stream().map(elementInfo -> IngredientFilter.checkForMatch(elementInfo, ingredientClass, ingredientUid, uidFunction)).filter(Optional::isPresent).map(Optional::get);
    }

    private static <T> Optional<IIngredientListElementInfo<T>> checkForMatch(IIngredientListElementInfo<?> info, Class<T> ingredientClass, String uid, Function<T, String> uidFunction) {
        return IngredientFilter.optionalCast(info, ingredientClass).filter(cast -> {
            String elementUid = (String)uidFunction.apply(cast.getElement().getIngredient());
            return uid.equals(elementUid);
        });
    }

    private static <T> Optional<IIngredientListElementInfo<T>> optionalCast(IIngredientListElementInfo<?> info, Class<T> ingredientClass) {
        Object ingredient = info.getElement().getIngredient();
        if (ingredientClass.isInstance(ingredient)) {
            IIngredientListElementInfo<?> cast = info;
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    private Set<IIngredientListElementInfo<?>> getSearchResults(SearchTokens searchTokens) {
        List resultsPerToken = (List)searchTokens.toSearch.stream().map(this.elementSearch::getSearchResults).collect(ImmutableList.toImmutableList());
        Set<IIngredientListElementInfo<IIngredientListElementInfo<?>>> results = IngredientFilter.intersection(resultsPerToken);
        if (!results.isEmpty() && !searchTokens.toRemove.isEmpty()) {
            for (ElementPrefixParser.TokenInfo tokenInfo : searchTokens.toRemove) {
                Set<IIngredientListElementInfo<?>> resultsToRemove = this.elementSearch.getSearchResults(tokenInfo);
                results.removeAll(resultsToRemove);
                if (!results.isEmpty()) continue;
                break;
            }
        }
        return results;
    }

    private static <T> Set<T> intersection(List<Set<T>> sets) {
        Set<T> set;
        Set smallestSet = sets.stream().min(Comparator.comparing(Set::size)).orElseGet(ImmutableSet::of);
        Set results = Collections.newSetFromMap(new IdentityHashMap());
        results.addAll(smallestSet);
        Iterator<Set<T>> iterator = sets.iterator();
        while (!(!iterator.hasNext() || (set = iterator.next()) != smallestSet && results.retainAll(set) && results.isEmpty())) {
        }
        return results;
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }

    public <V> boolean updateHiddenState(IIngredientListElement<V> element) {
        V ingredient = element.getIngredient();
        boolean visible = this.isIngredientVisible(ingredient);
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            return true;
        }
        return false;
    }

    public <V> boolean isIngredientVisible(V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        return this.isIngredientVisible(ingredient, ingredientHelper);
    }

    public <V> boolean isIngredientVisible(V ingredient, IIngredientHelper<V> ingredientHelper) {
        if (this.blacklist.isIngredientBlacklistedByApi(ingredient, ingredientHelper)) {
            return false;
        }
        if (!ingredientHelper.isIngredientOnServer(ingredient)) {
            return false;
        }
        return this.worldConfig.isEditModeEnabled() || !this.editModeConfig.isIngredientOnConfigBlacklist(ingredient, ingredientHelper);
    }

    private static final class SearchTokens {
        private final List<ElementPrefixParser.TokenInfo> toSearch;
        private final List<ElementPrefixParser.TokenInfo> toRemove;

        private SearchTokens(List<ElementPrefixParser.TokenInfo> toSearch, List<ElementPrefixParser.TokenInfo> toRemove) {
            this.toSearch = toSearch;
            this.toRemove = toRemove;
        }
    }
}

