/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.enchantment;

import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.enchantment.EnchantmentTicking;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.inventory.EquipmentSlotType;

public class EnchantmentAttribute
extends EnchantmentTicking {
    private final Map<Attribute, AttributeModifier> modifiers = new HashMap<Attribute, AttributeModifier>();

    public EnchantmentAttribute(Enchantment.Rarity rarity, EnchantmentType type, EquipmentSlotType ... slots) {
        super(rarity, type, slots);
    }

    public EnchantmentAttribute addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        this.modifiers.put(attribute, modifier);
        return this;
    }

    public Map<Attribute, AttributeModifier> getModifiers(int level) {
        return this.modifiers;
    }

    protected void removeModifiers(LivingEntity living, int level) {
        AttributeModifierManager attributeMap = living.func_233645_dx_();
        for (Map.Entry<Attribute, AttributeModifier> entry : this.getModifiers(level).entrySet()) {
            ModifiableAttributeInstance modifiable = attributeMap.func_233779_a_(entry.getKey());
            if (modifiable == null) continue;
            modifiable.func_111124_b(entry.getValue());
        }
    }

    protected void applyModifiers(LivingEntity living, int level) {
        AttributeModifierManager attributeMap = living.func_233645_dx_();
        for (Map.Entry<Attribute, AttributeModifier> entry : this.getModifiers(level).entrySet()) {
            ModifiableAttributeInstance modifiable = attributeMap.func_233779_a_(entry.getKey());
            if (modifiable == null) continue;
            AttributeModifier effectModifier = entry.getValue();
            modifiable.func_111124_b(effectModifier);
            modifiable.func_233769_c_(effectModifier);
        }
    }

    @Override
    public void onUserTick(LivingEntity user, int level) {
        this.removeModifiers(user, level);
        if (level > 0) {
            this.applyModifiers(user, level);
        }
    }
}

