/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;

public final class MathsUtils {
    public static final DecimalFormat DECIMAL_2 = new DecimalFormat("##.##");

    public static boolean isInRange(double min, double max, double value) {
        return value <= max && value >= min;
    }

    public static double getDistanceBetweenPoints(Vector3d firstPos, Vector3d secondPos) {
        double distanceX = firstPos.field_72450_a - secondPos.field_72450_a;
        double distanceY = firstPos.field_72448_b - secondPos.field_72448_b;
        double distanceZ = firstPos.field_72449_c - secondPos.field_72449_c;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    public static double round(double value, int places) {
        return value >= 0.0 && places > 0 ? BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue() : value;
    }

    public static int nextIntInclusive(Random rand, int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static boolean tryPercentage(double percent) {
        return Math.random() < percent;
    }

    public static int getAverage(int first, int second) {
        return Math.round((float)(first + second) / 2.0f);
    }

    public static String ticksToTime(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        return minutes + ":" + seconds;
    }

    public static int getPercentage(int value, int total) {
        return (int)((float)value / (float)total * 100.0f);
    }

    public static double getPixelDistance(int pixels) {
        return (double)pixels / 16.0;
    }

    public static AxisAlignedBB getBoundsForPixels(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new AxisAlignedBB(MathsUtils.getPixelDistance(minX), MathsUtils.getPixelDistance(minY), MathsUtils.getPixelDistance(minZ), MathsUtils.getPixelDistance(maxX), MathsUtils.getPixelDistance(maxY), MathsUtils.getPixelDistance(maxZ));
    }

    public static int adjustToRange(int initial, int min, int max) {
        return initial < min ? min : (initial > max ? max : initial);
    }

    public static int multiplyColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Map<Direction, VoxelShape> createHorizontalShapes(double x1, double y1, double z1, double x2, double y2, double z2) {
        EnumMap<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        Direction.Plane.HORIZONTAL.forEach(dir -> shapes.put((Direction)dir, MathsUtils.rotateShape(dir, x1, y1, z1, x2, y2, z2)));
        return shapes;
    }

    public static VoxelShape rotateShape(Direction facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        switch (facing) {
            case NORTH: {
                return Block.func_208617_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case EAST: {
                return Block.func_208617_a((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
            case SOUTH: {
                return Block.func_208617_a((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            }
            case WEST: {
                return Block.func_208617_a((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            }
        }
        throw new IllegalArgumentException("Can not rotate face in direction " + facing.name());
    }
}

