/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.client;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class EntitySkinHelper<E extends Entity> {
    private final Map<String, ResourceLocation> skins = Maps.newHashMap();
    private final String modId;
    private final String formattablePath;

    private EntitySkinHelper(String modId, String path, @Nullable String prefix) {
        this.modId = modId;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.formattablePath = prefix != null ? path + prefix + "_%s.png" : path + "%s.png";
    }

    public static <E extends Entity> EntitySkinHelper<E> create(String modId, String path, String prefix, Consumer<EntitySkinHelper<E>> consumer) {
        EntitySkinHelper<E> skinHelper = new EntitySkinHelper<E>(modId, path, prefix);
        consumer.accept(skinHelper);
        return skinHelper;
    }

    public static <E extends Entity> EntitySkinHelper<E> createWithoutPrefix(String modId, String path, Consumer<EntitySkinHelper<E>> consumer) {
        EntitySkinHelper<E> skinHelper = new EntitySkinHelper<E>(modId, path, null);
        consumer.accept(skinHelper);
        return skinHelper;
    }

    public void putSkins(String skinTexture, String ... skinNames) {
        ResourceLocation skinTextureLocation = this.createTextureLocation(skinTexture);
        for (String skin : skinNames) {
            this.skins.put(skin, skinTextureLocation);
        }
    }

    public void putSkin(String skinTexture, String skinName) {
        this.skins.put(skinName, this.createTextureLocation(skinTexture));
    }

    private ResourceLocation createTextureLocation(String skin) {
        return new ResourceLocation(this.modId, String.format(this.formattablePath, skin));
    }

    @Nullable
    public ResourceLocation getSkinForEntity(E entity) {
        return entity.func_145818_k_() ? this.skins.get(entity.func_200201_e().getString().toLowerCase().trim()) : null;
    }

    @Nonnull
    public ResourceLocation getSkinForEntityOrElse(E entity, ResourceLocation otherSkinTexture) {
        ResourceLocation skin = this.getSkinForEntity(entity);
        return skin != null ? skin : otherSkinTexture;
    }
}

