/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.AdvancementModifier;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.ArrayUtils;

public final class CriteriaModifier
extends AdvancementModifier<Config> {
    public static final Field REQUIREMENTS_FIELD = ObfuscationReflectionHelper.findField(Advancement.Builder.class, (String)"field_192066_f");

    public CriteriaModifier() {
        super((element, conditionArrayParser) -> {
            Optional<Map<String, Criterion>> criteria;
            JsonObject object = element.getAsJsonObject();
            AdvancementModifier.Mode mode = AdvancementModifier.Mode.deserialize(object);
            Optional<Map<String, Object>> optional = criteria = JSONUtils.func_151204_g((JsonObject)object, (String)"criteria") ? Optional.of(Criterion.func_232634_b_((JsonObject)JSONUtils.func_152754_s((JsonObject)object, (String)"criteria"), (ConditionArrayParser)conditionArrayParser)) : Optional.empty();
            if (criteria.isPresent() && ((Map)criteria.get()).isEmpty()) {
                throw new JsonParseException("Advancement criteria cannot be empty");
            }
            Optional<String[][]> requirements = Optional.empty();
            if (JSONUtils.func_151204_g((JsonObject)object, (String)"requirements")) {
                JsonArray jsonArray = JSONUtils.func_151213_a((JsonObject)object, (String)"requirements", (JsonArray)new JsonArray());
                String[][] requirementsArray = new String[jsonArray.size()][];
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonArray requirementsArray2 = JSONUtils.func_151207_m((JsonElement)jsonArray.get(i), (String)("requirements[" + i + "]"));
                    requirementsArray[i] = new String[requirementsArray2.size()];
                    for (int j = 0; j < requirementsArray2.size(); ++j) {
                        requirementsArray[i][j] = JSONUtils.func_151206_a((JsonElement)requirementsArray2.get(j), (String)("requirements[" + i + "][" + j + "]"));
                    }
                }
                Map<String, Criterion> map = criteria.orElse(Maps.newHashMap());
                if (requirementsArray.length == 0) {
                    requirementsArray = new String[map.size()][];
                    int i = 0;
                    for (String key : map.keySet()) {
                        requirementsArray[i++] = new String[]{key};
                    }
                }
                for (String[] requirementArray : requirementsArray) {
                    if (requirementArray.length == 0 && map.isEmpty()) {
                        throw new JsonParseException("Requirement entry cannot be empty");
                    }
                    String[] stringArray = requirementArray;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String criterion = stringArray[i];
                        if (map.containsKey(criterion)) continue;
                        throw new JsonParseException("Unknown required criterion '" + criterion + "'");
                    }
                }
                for (String key : map.keySet()) {
                    boolean required = false;
                    for (Object[] objectArray : requirementsArray) {
                        if (!ArrayUtils.contains((Object[])objectArray, (Object)key)) continue;
                        required = true;
                        break;
                    }
                    if (required) continue;
                    throw new JsonParseException("Criterion '" + key + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
                }
                requirements = Optional.of(requirementsArray);
            }
            return new Config(mode, criteria, requirements);
        });
    }

    @Override
    public void modify(Advancement.Builder builder, Config config) {
        Map criteria = builder.func_200277_c();
        try {
            String[][] requirementsArray = (String[][])REQUIREMENTS_FIELD.get(builder);
            if (config.mode == AdvancementModifier.Mode.MODIFY) {
                if (config.requirements.isPresent()) {
                    String[][] configRequirements = (String[][])config.requirements.get();
                    requirementsArray = (String[][])ArrayUtils.addAll((Object[])requirementsArray, (Object[])configRequirements);
                }
                REQUIREMENTS_FIELD.set(builder, requirementsArray);
            } else {
                criteria.clear();
                REQUIREMENTS_FIELD.set(builder, config.requirements.orElseGet(() -> new String[0][]));
            }
            config.criterionMap.ifPresent(criteria::putAll);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    static class Config {
        private final AdvancementModifier.Mode mode;
        private final Optional<Map<String, Criterion>> criterionMap;
        private final Optional<String[][]> requirements;

        Config(AdvancementModifier.Mode mode, Optional<Map<String, Criterion>> criterionMap, Optional<String[][]> requirements) {
            this.mode = mode;
            this.criterionMap = criterionMap;
            this.requirements = requirements;
        }
    }
}

