/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.loot.modification.modifiers;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecraftabnormals.abnormals_core.common.loot.modification.modifiers.ILootModifier;
import com.minecraftabnormals.abnormals_core.common.loot.modification.modifiers.LootPoolsModifier;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class LootPoolEntriesModifier
implements ILootModifier<Config> {
    public static final Field ENTRIES = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");

    @Override
    public void modify(LootTableLoadEvent object, Config config) {
        try {
            List lootEntries = (List)ENTRIES.get(((List)LootPoolsModifier.POOLS.get(object.getTable())).get(config.index));
            if (config.replace) {
                lootEntries.clear();
            }
            lootEntries.addAll(config.entries);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JsonElement serialize(Config config, Gson gson) throws JsonParseException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("replace", Boolean.valueOf(config.replace));
        jsonObject.addProperty("index", (Number)config.index);
        JsonArray entries = new JsonArray();
        for (LootEntry lootEntry : config.entries) {
            entries.add(gson.toJsonTree((Object)lootEntry));
        }
        jsonObject.add("entries", (JsonElement)entries);
        return jsonObject;
    }

    @Override
    public Config deserialize(JsonElement element, Pair<Gson, LootPredicateManager> additional) throws JsonParseException {
        JsonObject jsonObject = element.getAsJsonObject();
        int index = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"index");
        if (index < 0) {
            throw new JsonParseException("'index' must be 0 or greater!");
        }
        ArrayList<LootEntry> entries = new ArrayList<LootEntry>();
        JsonArray entriesArray = jsonObject.getAsJsonArray("entries");
        Gson gson = (Gson)additional.getFirst();
        entriesArray.forEach(entry -> entries.add((LootEntry)gson.fromJson(entry, LootEntry.class)));
        return new Config(JSONUtils.func_151212_i((JsonObject)jsonObject, (String)"replace"), index, entries);
    }

    public static class Config {
        private final boolean replace;
        private final int index;
        private final List<LootEntry> entries;

        public Config(boolean replace, int index, List<LootEntry> entries) {
            this.replace = replace;
            this.index = index;
            this.entries = entries;
        }
    }
}

