/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.api;

import java.util.Random;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public final class AdvancedRandomPositionGenerator {
    @Nullable
    public static Vector3d findRandomTarget(CreatureEntity creature, int xz, int y, boolean goDeep) {
        return AdvancedRandomPositionGenerator.findRandomTargetBlock(creature, xz, y, null, goDeep);
    }

    @Nullable
    private static Vector3d findRandomTargetBlock(CreatureEntity creature, int xz, int y, @Nullable Vector3d targetVec, boolean goDeep) {
        return AdvancedRandomPositionGenerator.generateRandomPos(creature, xz, y, targetVec, true, 1.5707963267948966, goDeep, arg_0 -> ((CreatureEntity)creature).func_180484_a(arg_0));
    }

    @Nullable
    private static Vector3d generateRandomPos(CreatureEntity creature, int xz, int y, @Nullable Vector3d p_191379_3_, boolean p_191379_4_, double p_191379_5_, boolean goDeep, ToDoubleFunction<BlockPos> p_191379_7_) {
        PathNavigator pathnavigator = creature.func_70661_as();
        Random random = creature.func_70681_au();
        boolean flag = creature.func_213394_dL() ? creature.func_213384_dI().func_218137_a((IPosition)creature.func_213303_ch(), (double)(creature.func_213391_dJ() + (float)xz) + 1.0) : false;
        boolean flag1 = false;
        double d0 = Double.NEGATIVE_INFINITY;
        BlockPos blockpos = new BlockPos(creature.func_213303_ch());
        for (int i = 0; i < 10; ++i) {
            double d1;
            BlockPos blockpos1 = AdvancedRandomPositionGenerator.getBlockPos(random, xz, y, p_191379_3_, p_191379_5_, goDeep);
            if (blockpos1 == null) continue;
            int j = blockpos1.func_177958_n();
            int k = blockpos1.func_177956_o();
            int l = blockpos1.func_177952_p();
            if (creature.func_213394_dL() && xz > 1) {
                BlockPos blockpos2 = creature.func_213384_dI();
                j = creature.func_226277_ct_() > (double)blockpos2.func_177958_n() ? (j -= random.nextInt(xz / 2)) : (j += random.nextInt(xz / 2));
                l = creature.func_226281_cx_() > (double)blockpos2.func_177952_p() ? (l -= random.nextInt(xz / 2)) : (l += random.nextInt(xz / 2));
            }
            BlockPos blockpos3 = new BlockPos((double)j + creature.func_226277_ct_(), (double)k + creature.func_226278_cu_(), (double)l + creature.func_226281_cx_());
            if (flag && !creature.func_213389_a(blockpos3) || !pathnavigator.func_188555_b(blockpos3) || !p_191379_4_ && AdvancedRandomPositionGenerator.isWaterDestination(blockpos3 = AdvancedRandomPositionGenerator.moveAboveSolid(blockpos3, creature), creature) || !((d1 = p_191379_7_.applyAsDouble(blockpos3)) > d0)) continue;
            d0 = d1;
            blockpos = blockpos3;
            flag1 = true;
        }
        if (flag1) {
            return Vector3d.func_237489_a_((Vector3i)blockpos);
        }
        return null;
    }

    @Nullable
    private static BlockPos getBlockPos(Random rand, int xz, int y, @Nullable Vector3d Vector3d2, double angle, boolean goDeep) {
        if (Vector3d2 != null && !(angle >= Math.PI)) {
            double d3 = MathHelper.func_181159_b((double)Vector3d2.field_72449_c, (double)Vector3d2.field_72450_a) - 1.5707963705062866;
            double d4 = d3 + (double)(2.0f * rand.nextFloat() - 1.0f) * angle;
            double d0 = Math.sqrt(rand.nextDouble()) * (double)MathHelper.field_180189_a * (double)xz;
            double d1 = -d0 * Math.sin(d4);
            double d2 = d0 * Math.cos(d4);
            if (!(Math.abs(d1) > (double)xz) && !(Math.abs(d2) > (double)xz)) {
                double newY = rand.nextInt(2 * y + 1) - y;
                return new BlockPos(d1, newY, d2);
            }
            return null;
        }
        int newX = rand.nextInt(2 * xz + 1) - xz;
        int newY = rand.nextInt(2 * y + 1) - y;
        int newZ = rand.nextInt(2 * xz + 1) - xz;
        if (goDeep) {
            newY = rand.nextInt(y + 1) - y * 2;
        }
        return new BlockPos(newX, newY, newZ);
    }

    private static BlockPos moveAboveSolid(BlockPos pos, CreatureEntity creature) {
        if (!creature.field_70170_p.func_180495_p(pos).func_185904_a().func_76220_a()) {
            return pos;
        }
        BlockPos blockpos = pos.func_177984_a();
        while (blockpos.func_177956_o() < creature.field_70170_p.func_217301_I() && creature.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76220_a()) {
            blockpos = blockpos.func_177984_a();
        }
        return blockpos;
    }

    private static boolean isWaterDestination(BlockPos pos, CreatureEntity creature) {
        return creature.field_70170_p.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }
}

