/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.endimator;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.minecraftabnormals.abnormals_core.core.AbnormalsCore;
import com.minecraftabnormals.abnormals_core.core.endimator.instructions.EndimationInstructionList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public final class EndimationDataManager
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(EndimationInstructionList.class, (Object)new EndimationInstructionListDeserializer()).create();
    public static final Map<ResourceLocation, EndimationInstructionList> ENDIMATIONS = Maps.newHashMap();

    public EndimationDataManager() {
        super(GSON, "endimations");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceMap, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceMap.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.func_110623_a().startsWith("_")) continue;
            try {
                EndimationInstructionList instructions = (EndimationInstructionList)GSON.fromJson(entry.getValue(), EndimationInstructionList.class);
                ENDIMATIONS.put(resourcelocation, instructions);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                AbnormalsCore.LOGGER.error("Parsing error loading Endimation {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        AbnormalsCore.LOGGER.info("Endimation Data Manager has loaded {} Endimations", (Object)ENDIMATIONS.size());
    }

    public static class EndimationInstructionListDeserializer
    implements JsonDeserializer<EndimationInstructionList> {
        public EndimationInstructionList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            DataResult decode = EndimationInstructionList.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.getAsJsonObject());
            Optional result = decode.result();
            if (result.isPresent()) {
                return (EndimationInstructionList)((Pair)result.get()).getFirst();
            }
            decode.error().ifPresent(error -> AbnormalsCore.LOGGER.error("Failed to decode Endimation: {}", (Object)error.toString()));
            return null;
        }
    }
}

