/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.endimator.entity;

import com.minecraftabnormals.abnormals_core.core.endimator.Endimation;
import com.minecraftabnormals.abnormals_core.core.endimator.entity.IEndimatedEntity;
import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;

public abstract class EndimatedGoal<E extends Entity>
extends Goal {
    protected final E entity;
    protected final Endimation endimation;
    protected final Random random;

    public EndimatedGoal(E entity, Endimation endimation) {
        this.entity = entity;
        this.endimation = endimation;
        this.random = new Random();
    }

    protected void playEndimation() {
        NetworkUtil.setPlayingAnimationMessage(this.entity, this.endimation);
    }

    protected void playEndimation(Endimation endimation) {
        NetworkUtil.setPlayingAnimationMessage(this.entity, endimation);
    }

    protected boolean isEndimationPlaying() {
        return ((IEndimatedEntity)this.entity).isEndimationPlaying(this.endimation);
    }

    protected boolean isEndimationPlaying(Endimation endimation) {
        return ((IEndimatedEntity)this.entity).isEndimationPlaying(endimation);
    }

    protected boolean isNoEndimationPlaying() {
        return ((IEndimatedEntity)this.entity).isNoEndimationPlaying();
    }

    protected boolean isEndimationAtTick(int tick) {
        return ((IEndimatedEntity)this.entity).getAnimationTick() == tick;
    }

    protected boolean isEndimationPastTick(int tick) {
        return ((IEndimatedEntity)this.entity).getAnimationTick() > tick;
    }

    protected boolean isEndimationPastOrAtTick(int tick) {
        return ((IEndimatedEntity)this.entity).getAnimationTick() >= tick;
    }

    protected boolean isEndimationBeforeTick(int tick) {
        return ((IEndimatedEntity)this.entity).getAnimationTick() < tick;
    }

    protected boolean isEndimationBeforeOrAtTick(int tick) {
        return ((IEndimatedEntity)this.entity).getAnimationTick() <= tick;
    }
}

