/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.registry;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="abnormals_core")
public final class LootInjectionRegistry {
    private static final Set<Pair<Set<ResourceLocation>, LootPool>> POOL_INJECTORS = Sets.newHashSet();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        POOL_INJECTORS.forEach(setLootPoolPair -> {
            if (((Set)setLootPoolPair.getFirst()).contains(event.getName())) {
                event.getTable().addPool((LootPool)setLootPoolPair.getSecond());
            }
        });
    }

    public static synchronized void addLootInjector(Set<ResourceLocation> locations, LootPool lootPool) {
        POOL_INJECTORS.add((Pair<Set<ResourceLocation>, LootPool>)Pair.of(locations, (Object)lootPool));
    }

    public static class LootInjector {
        private final String modId;

        public LootInjector(String modId) {
            this.modId = modId;
        }

        public void addLootInjection(String name, int weight, int quality, ResourceLocation ... locations) {
            LootInjectionRegistry.addLootInjector(Sets.newHashSet((Object[])locations), this.buildLootPool(name, weight, quality));
        }

        public void addLootInjection(LootPool pool, ResourceLocation ... locations) {
            LootInjectionRegistry.addLootInjector(Sets.newHashSet((Object[])locations), pool);
        }

        public LootPool buildLootPool(String name, int weight, int quality) {
            return LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(this.modId, "injections/" + name)).func_216086_a(weight).func_216085_b(quality)).name(this.modId + name).func_216044_b();
        }
    }
}

