/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util;

import java.util.List;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.fml.ModList;

public final class TradeUtil {
    public static final int NOVICE = 1;
    public static final int APPRENTICE = 2;
    public static final int JOURNEYMAN = 3;
    public static final int EXPERT = 4;
    public static final int MASTER = 5;

    public static void addVillagerTrades(VillagerTradesEvent event, int level, VillagerTrades.ITrade ... trades) {
        for (VillagerTrades.ITrade trade : trades) {
            ((List)event.getTrades().get(level)).add(trade);
        }
    }

    public static void addVillagerTrades(VillagerTradesEvent event, VillagerProfession profession, int level, VillagerTrades.ITrade ... trades) {
        if (event.getType() == profession) {
            TradeUtil.addVillagerTrades(event, level, trades);
        }
    }

    public static void addWandererTrades(WandererTradesEvent event, VillagerTrades.ITrade ... trades) {
        for (VillagerTrades.ITrade trade : trades) {
            event.getGenericTrades().add(trade);
        }
    }

    public static void addRareWandererTrades(WandererTradesEvent event, VillagerTrades.ITrade ... trades) {
        for (VillagerTrades.ITrade trade : trades) {
            event.getRareTrades().add(trade);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, int level, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            TradeUtil.addVillagerTrades(event, level, trades);
        }
    }

    public static void addCompatVillagerTrades(VillagerTradesEvent event, String modid, VillagerProfession profession, int level, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            TradeUtil.addVillagerTrades(event, profession, level, trades);
        }
    }

    public static void addCompatWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            TradeUtil.addWandererTrades(event, trades);
        }
    }

    public static void addCompatRareWandererTrades(WandererTradesEvent event, String modid, VillagerTrades.ITrade ... trades) {
        if (ModList.get().isLoaded(modid)) {
            TradeUtil.addRareWandererTrades(event, trades);
        }
    }

    public static class AbnormalsTrade
    extends BasicTrade {
        public AbnormalsTrade(ItemStack input, ItemStack input2, ItemStack output, int maxTrades, int xp, float priceMult) {
            super(input, input2, output, maxTrades, xp, priceMult);
        }

        public AbnormalsTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((IItemProvider)input, inputCount), ItemStack.field_190927_a, new ItemStack((IItemProvider)output, outputCount), maxTrades, xp, priceMult);
        }

        public AbnormalsTrade(Item input, int inputCount, Item output, int outputCount, int maxTrades, int xp) {
            this(input, inputCount, output, outputCount, maxTrades, xp, 0.15f);
        }

        public AbnormalsTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((IItemProvider)input, inputCount), ItemStack.field_190927_a, new ItemStack((IItemProvider)Items.field_151166_bC, emeraldCount), maxTrades, xp, priceMult);
        }

        public AbnormalsTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp) {
            this(input, inputCount, emeraldCount, maxTrades, xp, 0.15f);
        }

        public AbnormalsTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp, float priceMult) {
            this(new ItemStack((IItemProvider)Items.field_151166_bC, emeraldCount), ItemStack.field_190927_a, new ItemStack((IItemProvider)output, outputCount), maxTrades, xp, priceMult);
        }

        public AbnormalsTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp) {
            this(emeraldCount, output, outputCount, maxTrades, xp, 0.15f);
        }
    }
}

