/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.screen;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.render.ShapeRenderer;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.screen.ValueContainerEditorScreen;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.screen.ValueContainerEntrySliderImpl;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.screen.ValueContainerEntrySwitchImpl;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.screen.ValueContainerEntryToggleImpl;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.util.FontHelper;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.util.ScissorHelper;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.util.ScrollHandler;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.ValueContainer;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.ValueContainerEntry;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ValueContainerEditorScreenImpl
extends ValueContainerEditorScreen {
    public static final double MAX_SCROLL = 2.0;
    public static final int WIDTH = 176;
    public static final int HEIGHT = 166;
    public static final int VALUE_HEIGHT = 35;
    private final int xSize;
    private final int ySize;
    private final List<Widget> entryWidgets = new ArrayList<Widget>();
    private final ScrollHandler scrollHandler = new ScrollHandler(null, this.getEntries().size() * 35, 142);
    private boolean scrolling;

    public ValueContainerEditorScreenImpl(ValueContainer container, BlockPos pos, Supplier<ITextComponent> defaultTitle) {
        super(container, pos, defaultTitle);
        this.xSize = 176;
        this.ySize = 166;
        this.scrollHandler.setScrollSpeed(this.scrollHandler.getMaxScroll() / (float)this.getEntries().size());
        this.scrolling = false;
    }

    private void renderLabels(MatrixStack matrixStack, float partialTicks) {
        float scroll = this.scrollHandler.getInterpolatedScroll(partialTicks);
        for (int i = 0; i < this.getEntries().size(); ++i) {
            float y = 2 + i * 35;
            if (y - scroll + 35.0f < 0.0f) continue;
            if (y - scroll >= 160.0f) break;
            ValueContainerEntry<?> entry = this.getEntries().get(i);
            FontHelper.drawString(matrixStack, this.getMinecraft().field_71466_p, entry.getDisplayName().getString(), 8.0f, 18.0f + y, -1, true);
        }
    }

    protected void func_231160_c_() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.func_230480_a_((Widget)new Button((this.field_230708_k_ - this.xSize) / 2, (this.field_230709_l_ + this.ySize) / 2 + 4, this.xSize, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.getMinecraft().func_147108_a(null)));
        block6: for (int i = 0; i < this.getEntries().size(); ++i) {
            ValueContainerEntry<?> entry = this.getEntries().get(i);
            switch (entry.getInputType()) {
                case TEXT_FIELD: {
                    Optional<Predicate<String>> optional = entry.getValidator();
                    FontRenderer fontRenderer = this.getMinecraft().field_71466_p;
                    this.getMinecraft().field_71466_p.getClass();
                    TextFieldWidget textField = new TextFieldWidget(fontRenderer, 8, 22 + 9 + i * 35, 144, 20, (ITextComponent)new StringTextComponent(""));
                    textField.func_146203_f(Integer.MAX_VALUE);
                    textField.func_146180_a(entry.getDisplay());
                    textField.func_212954_a(text -> {
                        boolean valid = !optional.isPresent() || ((Predicate)optional.get()).test(text);
                        textField.func_146193_g(valid ? 0xE0E0E0 : 0xFF5555);
                        if (valid) {
                            entry.parse((String)text);
                        }
                    });
                    this.entryWidgets.add((Widget)textField);
                    continue block6;
                }
                case TOGGLE: {
                    this.getMinecraft().field_71466_p.getClass();
                    this.entryWidgets.add((Widget)new ValueContainerEntryToggleImpl(entry, 8, 22 + 9 + i * 35, 144, 20));
                    continue block6;
                }
                case SWITCH: {
                    this.getMinecraft().field_71466_p.getClass();
                    this.entryWidgets.add((Widget)new ValueContainerEntrySwitchImpl(entry, 8, 22 + 9 + i * 35, 144, 20));
                    continue block6;
                }
                case SLIDER: {
                    this.getMinecraft().field_71466_p.getClass();
                    this.entryWidgets.add((Widget)new ValueContainerEntrySliderImpl(entry, 8, 22 + 9 + i * 35, 144, 20));
                }
            }
        }
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        this.entryWidgets.clear();
        super.func_231158_b_(minecraft, width, height);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230706_i_ == null) {
            return;
        }
        partialTicks = this.getMinecraft().func_184121_ak();
        super.func_230446_a_(matrixStack);
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        for (Widget widget : this.field_230710_m_) {
            widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)(this.field_230708_k_ - this.xSize) / 2.0f), (double)((float)(this.field_230709_l_ - this.ySize) / 2.0f), 0.0);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)(-this.scrollHandler.getInterpolatedScroll(partialTicks)), 0.0);
        ScissorHelper.push((float)(this.field_230708_k_ - this.xSize) / 2.0f + 6.0f, (float)(this.field_230709_l_ - this.ySize) / 2.0f + 18.0f, 148.0f, 142.0f);
        this.renderWidgets(matrixStack, mouseX - (int)((float)(this.field_230708_k_ - this.xSize) / 2.0f), mouseY - (int)((float)(this.field_230709_l_ - this.ySize) / 2.0f) + (int)this.scrollHandler.getInterpolatedScroll(partialTicks), partialTicks);
        this.renderLabels(matrixStack, partialTicks);
        ScissorHelper.pop();
        matrixStack.func_227865_b_();
        this.renderForeground(matrixStack, mouseX - (int)((float)(this.field_230708_k_ - this.xSize) / 2.0f), mouseY - (int)((float)(this.field_230709_l_ - this.ySize) / 2.0f), partialTicks);
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderWidgets(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        float scroll = this.scrollHandler.getInterpolatedScroll(partialTicks);
        for (Widget widget : this.entryWidgets) {
            if ((float)widget.field_230691_m_ - scroll + (float)widget.func_238483_d_() < 0.0f) continue;
            if ((float)widget.field_230691_m_ - scroll >= 160.0f) break;
            widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void renderBackground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        float screenX = (float)(this.field_230708_k_ - this.xSize) / 2.0f;
        float screenY = (float)(this.field_230709_l_ - this.ySize) / 2.0f;
        this.getMinecraft().func_110434_K().func_110577_a(this.getBackgroundTextureLocation());
        ShapeRenderer.drawRectWithTexture(matrixStack, (double)screenX, (double)screenY, 0.0f, 0.0f, (double)this.xSize, this.ySize);
    }

    @Override
    protected void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.getMinecraft().field_71466_p.func_238421_b_(matrixStack, this.getFormattedTitle(), (float)(this.xSize - this.getMinecraft().field_71466_p.func_78256_a(this.getFormattedTitle())) / 2.0f, 6.0f, 0x404040);
        this.getMinecraft().func_110434_K().func_110577_a(this.getBackgroundTextureLocation());
        boolean hasScroll = this.scrollHandler.getMaxScroll() > 0.0f;
        float scrollbarY = hasScroll ? 127.0f * (this.scrollHandler.getInterpolatedScroll(partialTicks) / this.scrollHandler.getMaxScroll()) : 0.0f;
        ShapeRenderer.drawRectWithTexture(matrixStack, 158.0, (double)(18.0f + scrollbarY), hasScroll ? 176.0f : 188.0f, 0.0f, 12.0, 15.0);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.entryWidgets.forEach(this::tickChild);
        this.scrollHandler.update();
    }

    @Override
    public void func_231164_f_() {
        super.func_231164_f_();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public Optional<IGuiEventListener> getEntryWidgetForPos(double mouseX, double mouseY) {
        mouseX -= (double)((float)(this.field_230708_k_ - this.xSize) / 2.0f);
        mouseY -= (double)((float)(this.field_230709_l_ - this.ySize) / 2.0f);
        float scroll = this.scrollHandler.getInterpolatedScroll(Minecraft.func_71410_x().func_184121_ak());
        if (mouseX >= 6.0 && mouseX < 148.0 && mouseY + (double)scroll >= 18.0 && mouseY + (double)scroll < 159.0) {
            for (IGuiEventListener iGuiEventListener : this.entryWidgets) {
                if (!iGuiEventListener.func_231047_b_(mouseX, mouseY)) continue;
                return Optional.of(iGuiEventListener);
            }
        }
        return Optional.empty();
    }

    private boolean componentClicked(double mouseX, double mouseY, int mouseButton) {
        for (IGuiEventListener iguieventlistener : this.func_231039_at__()) {
            if (!iguieventlistener.func_231044_a_(mouseX, mouseY, mouseButton)) continue;
            this.func_231035_a_(iguieventlistener);
            if (mouseButton == 0) {
                this.func_231037_b__(true);
            }
            return true;
        }
        return false;
    }

    private boolean entryComponentClicked(double mouseX, double mouseY, int mouseButton) {
        float scroll = this.scrollHandler.getInterpolatedScroll(Minecraft.func_71410_x().func_184121_ak());
        for (IGuiEventListener iGuiEventListener : this.entryWidgets) {
            if (!iGuiEventListener.func_231044_a_(mouseX - (double)((float)(this.field_230708_k_ - this.xSize) / 2.0f), mouseY - (double)((float)(this.field_230709_l_ - this.ySize) / 2.0f) + (double)scroll, mouseButton)) continue;
            this.func_231035_a_(iGuiEventListener);
            if (mouseButton == 0) {
                this.func_231037_b__(true);
            }
            return true;
        }
        return false;
    }

    private boolean clickScrollbar(double mouseX, double mouseY) {
        mouseX -= (double)((float)(this.field_230708_k_ - this.xSize) / 2.0f);
        mouseY -= (double)((float)(this.field_230709_l_ - this.ySize) / 2.0f);
        if (this.scrollHandler.getMaxScroll() > 0.0f && mouseX >= 158.0 && mouseX < 169.0 && mouseY >= 18.0 && mouseY < 160.0) {
            this.scrolling = true;
            this.scrollHandler.setScroll(this.scrollHandler.getMaxScroll() * (float)MathHelper.func_151237_a((double)((mouseY - 25.0) / 128.0), (double)0.0, (double)1.0));
            return true;
        }
        return false;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean flag = false;
        if (!this.componentClicked(mouseX, mouseY, mouseButton) && !this.entryComponentClicked(mouseX, mouseY, mouseButton)) {
            if (this.func_241217_q_() != null && !this.func_241217_q_().func_231047_b_(mouseX, mouseY)) {
                this.func_231035_a_(null);
            }
            flag = true;
        }
        return !flag || this.clickScrollbar(mouseX, mouseY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.scrolling = false;
        if (super.func_231048_c_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return this.getEntryWidgetForPos(mouseX, mouseY).filter(iguieventlistener -> iguieventlistener.func_231048_c_(mouseX, mouseY, mouseButton)).isPresent();
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        IGuiEventListener focused = this.func_241217_q_();
        if (focused != null && this.func_231041_ay__() && mouseButton == 0) {
            if (focused instanceof Widget && this.entryWidgets.contains(focused)) {
                return focused.func_231045_a_(mouseX - (double)((float)(this.field_230708_k_ - this.xSize) / 2.0f), mouseY - (double)((float)(this.field_230709_l_ - this.ySize) / 2.0f), mouseButton, deltaX, deltaY);
            }
            if (super.func_231045_a_(mouseX, mouseY, mouseButton, deltaX, deltaY)) {
                return true;
            }
        }
        if (this.scrollHandler.getMaxScroll() > 0.0f && this.scrolling) {
            this.scrollHandler.setScroll(this.scrollHandler.getMaxScroll() * (float)MathHelper.func_151237_a((double)((mouseY - (double)((float)(this.field_230709_l_ - this.ySize) / 2.0f) - 25.0) / 128.0), (double)0.0, (double)1.0));
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (super.func_231043_a_(mouseX, mouseY, amount)) {
            return true;
        }
        return this.func_212930_a(mouseX, mouseY).filter(iguieventlistener -> iguieventlistener.func_231043_a_(mouseX - (double)((float)(this.field_230708_k_ - this.xSize) / 2.0f), mouseY - (double)((float)(this.field_230709_l_ - this.ySize) / 2.0f), amount)).isPresent() || this.scrollHandler.mouseScrolled(2.0, amount);
    }

    public boolean func_231049_c__(boolean p_changeFocus_1_) {
        IGuiEventListener iguieventlistener = this.func_241217_q_();
        if (iguieventlistener != null && iguieventlistener.func_231049_c__(p_changeFocus_1_)) {
            return true;
        }
        if (this.changeFocus(p_changeFocus_1_, this.entryWidgets, iguieventlistener)) {
            return true;
        }
        if (this.changeFocus(p_changeFocus_1_, this.func_231039_at__(), iguieventlistener)) {
            return true;
        }
        this.func_231035_a_(null);
        return false;
    }

    private boolean changeFocus(boolean p_changeFocus_1_, List<? extends IGuiEventListener> list, @Nullable IGuiEventListener focused) {
        Supplier<IGuiEventListener> supplier;
        BooleanSupplier booleansupplier;
        int j = list.indexOf(focused);
        int i = focused != null && j >= 0 ? j + (p_changeFocus_1_ ? 1 : 0) : (p_changeFocus_1_ ? 0 : list.size());
        ListIterator<? extends IGuiEventListener> listiterator = list.listIterator(i);
        BooleanSupplier booleanSupplier = p_changeFocus_1_ ? listiterator::hasNext : (booleansupplier = listiterator::hasPrevious);
        Supplier<IGuiEventListener> supplier2 = p_changeFocus_1_ ? listiterator::next : (supplier = listiterator::previous);
        while (booleansupplier.getAsBoolean()) {
            IGuiEventListener iguieventlistener1 = supplier.get();
            if (!iguieventlistener1.func_231049_c__(p_changeFocus_1_)) continue;
            this.func_231035_a_(iguieventlistener1);
            return true;
        }
        return false;
    }

    public abstract ResourceLocation getBackgroundTextureLocation();
}

