/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.ValueContainerEntry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractVectorValueContainerEntry<T>
implements ValueContainerEntry<T> {
    private final ITextComponent displayName;
    private final String name;
    private final T minValue;
    private final T maxValue;
    private final T previousValue;
    protected T value;
    private Predicate<String> validator;

    public AbstractVectorValueContainerEntry(ITextComponent displayName, String name, T value, @Nullable T minValue, @Nullable T maxValue, boolean allowDecimals) {
        this.displayName = displayName;
        this.name = name;
        this.previousValue = value;
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.validator = AbstractVectorValueContainerEntry.createDefaultValidator(this, allowDecimals);
    }

    protected T clamp(T value, @Nullable T minValue, @Nullable T maxValue) {
        if (minValue == null && maxValue == null) {
            return value;
        }
        double x = this.getX(value).doubleValue();
        double y = this.getY(value).doubleValue();
        double z = this.getZ(value).doubleValue();
        if (minValue != null) {
            if (x < this.getX(minValue).doubleValue()) {
                x = this.getX(minValue).doubleValue();
            }
            if (y < this.getY(minValue).doubleValue()) {
                y = this.getY(minValue).doubleValue();
            }
            if (z < this.getZ(minValue).doubleValue()) {
                z = this.getZ(minValue).doubleValue();
            }
        }
        if (maxValue != null) {
            if (x > this.getX(maxValue).doubleValue()) {
                x = this.getX(maxValue).doubleValue();
            }
            if (y < this.getX(maxValue).doubleValue()) {
                y = this.getX(maxValue).doubleValue();
            }
            if (z < this.getX(maxValue).doubleValue()) {
                z = this.getX(maxValue).doubleValue();
            }
        }
        return this.create(x, y, z);
    }

    protected abstract T create(Number var1, Number var2, Number var3);

    protected abstract Number getX(T var1);

    protected abstract Number getY(T var1);

    protected abstract Number getZ(T var1);

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Nullable
    public T getMinValue() {
        return this.minValue;
    }

    @Nullable
    public T getMaxValue() {
        return this.maxValue;
    }

    @Override
    public <E> E getValue() {
        return (E)this.value;
    }

    @Override
    public <E> E getPreviousValue() {
        return (E)this.previousValue;
    }

    @Override
    public ValueContainerEntry.InputType getInputType() {
        return ValueContainerEntry.InputType.TEXT_FIELD;
    }

    @Override
    public boolean isDirty() {
        return !Objects.equals(this.value, this.previousValue);
    }

    @Override
    public String getDisplay() {
        return this.getX(this.value) + "," + this.getY(this.value) + "," + this.getZ(this.value);
    }

    @Override
    public Optional<Predicate<String>> getValidator() {
        return Optional.ofNullable(this.validator);
    }

    public AbstractVectorValueContainerEntry<T> setValidator(@Nullable Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    public static Predicate<String> createDefaultValidator(ValueContainerEntry<?> entry, boolean allowDecimals) {
        return s -> {
            String[] tokens = s.split(",", 4);
            if (tokens.length != 3) {
                return false;
            }
            for (String item : tokens) {
                Number value;
                String token = item.trim();
                if (StringUtils.isEmpty((CharSequence)token) || !NumberUtils.isCreatable((String)token)) {
                    return false;
                }
                if (allowDecimals || !((value = NumberUtils.createNumber((String)token)) instanceof Double) && !(value instanceof Float)) continue;
                return false;
            }
            return true;
        };
    }
}

