/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.SwitchEntry;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.ValueContainerEntry;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ArrayValueContainerEntry<T>
implements ValueContainerEntry<T>,
SwitchEntry {
    private final ITextComponent displayName;
    private final String name;
    private final T[] values;
    private final int previousIndex;
    private int index;
    private Function<T, String> displayGenerator;
    private Predicate<String> validator;

    public ArrayValueContainerEntry(ITextComponent displayName, String name, T[] values) {
        this(displayName, name, values, 0);
    }

    public ArrayValueContainerEntry(ITextComponent displayName, String name, T[] values, T value) {
        this(displayName, name, values, ArrayValueContainerEntry.getIndex(values, value));
    }

    public ArrayValueContainerEntry(ITextComponent displayName, String name, T[] values, int index) {
        this.displayName = displayName;
        this.name = name;
        this.values = values;
        this.previousIndex = index;
        this.index = index;
        this.displayGenerator = null;
        this.validator = ArrayValueContainerEntry.createDefaultValidator();
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ValueContainerEntry.InputType getInputType() {
        return ValueContainerEntry.InputType.SWITCH;
    }

    @Override
    public <E> E getValue() {
        return (E)this.values[this.index];
    }

    @Override
    public <E> E getPreviousValue() {
        return (E)this.values[this.previousIndex];
    }

    @Override
    public boolean isDirty() {
        return this.index != this.previousIndex;
    }

    @Override
    public String getDisplay() {
        return this.displayGenerator == null ? String.valueOf(this.getValue()) : this.displayGenerator.apply(this.getValue());
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74768_a(this.getName(), this.index);
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.index = nbt.func_150297_b(this.getName(), 99) ? nbt.func_74762_e(this.getName()) : this.previousIndex;
    }

    @Override
    public void parse(String data) {
        int index = NumberUtils.createNumber((String)data).intValue();
    }

    public Function<T, String> getDisplayGenerator() {
        return this.displayGenerator;
    }

    @Override
    public Optional<Predicate<String>> getValidator() {
        return Optional.ofNullable(this.validator);
    }

    public ArrayValueContainerEntry<T> setDisplayGenerator(@Nullable Function<T, String> displayGenerator) {
        this.displayGenerator = displayGenerator;
        return this;
    }

    public ArrayValueContainerEntry<T> setValidator(@Nullable Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    public static Predicate<String> createDefaultValidator() {
        return s -> !StringUtils.isEmpty((CharSequence)s.trim()) && NumberUtils.isCreatable((String)s.trim());
    }

    @Override
    public void showNext() {
        ++this.index;
        if (this.index >= this.values.length) {
            this.index = 0;
        }
    }

    @Override
    public void showPrevious() {
        --this.index;
        if (this.index < 0) {
            this.index = this.values.length - 1;
        }
    }

    private static int getIndex(Object[] values, Object value) {
        int index = ArrayUtils.indexOf((Object[])values, (Object)value);
        return index == -1 ? 0 : index;
    }
}

