/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.ValueContainerEntry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryObjectValueContainerEntry<T extends IForgeRegistryEntry<T>>
implements ValueContainerEntry<ResourceLocation> {
    private final ITextComponent displayName;
    private final String name;
    private final IForgeRegistry<T> registry;
    private final T previousValue;
    private T value;
    private Predicate<String> validator;

    public RegistryObjectValueContainerEntry(ITextComponent displayName, String name, IForgeRegistry<T> registry, T value) {
        this.displayName = displayName;
        this.name = name;
        this.registry = registry;
        this.previousValue = value;
        this.value = value;
        this.validator = RegistryObjectValueContainerEntry.createDefaultValidator(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public ValueContainerEntry.InputType getInputType() {
        return ValueContainerEntry.InputType.TEXT_FIELD;
    }

    @Override
    public <E> E getValue() {
        return (E)this.value;
    }

    @Override
    public <E> E getPreviousValue() {
        return (E)this.previousValue;
    }

    @Override
    public boolean isDirty() {
        return !this.value.equals(this.previousValue);
    }

    @Override
    public String getDisplay() {
        return Objects.requireNonNull(this.value.getRegistryName()).toString();
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74778_a(this.getName(), Objects.requireNonNull(this.value.getRegistryName()).toString());
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.value = nbt.func_150297_b(this.getName(), 8) ? this.registry.getValue(new ResourceLocation(nbt.func_74779_i(this.getName()))) : this.previousValue;
    }

    @Override
    public void parse(String data) {
        this.value = this.registry.getValue(new ResourceLocation(data));
    }

    @Override
    public Optional<Predicate<String>> getValidator() {
        return Optional.ofNullable(this.validator);
    }

    public RegistryObjectValueContainerEntry<T> setValidator(@Nullable Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    public static Predicate<String> createDefaultValidator(RegistryObjectValueContainerEntry<?> entry) {
        return s -> {
            if (!ResourceLocation.func_217855_b((String)s)) {
                return false;
            }
            return entry.registry.containsKey(new ResourceLocation(s));
        };
    }
}

